/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.config.SourceData;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public abstract class SecretsPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(SecretsPropertySourceLocator.class);
    private final SecretsCache cache;
    protected final SecretsConfigProperties properties;

    @Deprecated(forRemoval=true)
    public SecretsPropertySourceLocator(SecretsConfigProperties properties) {
        this.properties = properties;
        this.cache = new SecretsCache.NOOPCache();
    }

    public SecretsPropertySourceLocator(SecretsConfigProperties properties, SecretsCache cache) {
        this.properties = properties;
        this.cache = cache;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            List<NormalizedSource> sources = this.properties.determineSources(environment);
            HashSet<NormalizedSource> uniqueSources = new HashSet<NormalizedSource>(sources);
            LOG.debug((Object)("Secrets normalized sources : " + sources));
            CompositePropertySource composite = new CompositePropertySource("composite-secrets");
            this.putPathConfig(composite);
            if (this.properties.enableApi()) {
                uniqueSources.forEach(s -> composite.addPropertySource((PropertySource)this.getSecretsPropertySourceForSingleSecret(env, (NormalizedSource)s)));
            }
            this.cache.discardAll();
            return composite;
        }
        return null;
    }

    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return super.locateCollection(environment);
    }

    private SecretsPropertySource getSecretsPropertySourceForSingleSecret(ConfigurableEnvironment environment, NormalizedSource normalizedSource) {
        return this.getPropertySource(environment, normalizedSource);
    }

    protected abstract SecretsPropertySource getPropertySource(ConfigurableEnvironment var1, NormalizedSource var2);

    protected void putPathConfig(CompositePropertySource composite) {
        this.properties.paths().stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(x -> {
            try {
                return Files.walk(x, new FileVisitOption[0]);
            }
            catch (IOException e) {
                LOG.warn((Object)"Error walking properties files", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(new SecretsPropertySourceCollector()).forEach(arg_0 -> ((CompositePropertySource)composite).addPropertySource(arg_0));
    }

    private static class SecretsPropertySourceCollector
    implements Collector<Path, List<SecretsPropertySource>, List<SecretsPropertySource>> {
        private SecretsPropertySourceCollector() {
        }

        @Override
        public Supplier<List<SecretsPropertySource>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<SecretsPropertySource>, Path> accumulator() {
            return (list, filePath) -> {
                SecretsPropertySource source = this.property((Path)filePath);
                if (source != null) {
                    list.add(source);
                }
            };
        }

        @Override
        public BinaryOperator<List<SecretsPropertySource>> combiner() {
            return (left, right) -> {
                left.addAll(right);
                return left;
            };
        }

        @Override
        public Function<List<SecretsPropertySource>, List<SecretsPropertySource>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        }

        private SecretsPropertySource property(Path filePath) {
            String fileName = filePath.getFileName().toString();
            try {
                String content = new String(Files.readAllBytes(filePath)).trim();
                String sourceName = fileName.toLowerCase();
                SourceData sourceData = new SourceData(sourceName, Collections.singletonMap(fileName, content));
                return new SecretsPropertySource(sourceData);
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading properties file", (Throwable)e);
                return null;
            }
        }
    }
}

