/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.PropertySourceUtils;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.annotation.Retryable;

public abstract class ConfigMapPropertySourceLocator
implements PropertySourceLocator {
    private static final Log LOG = LogFactory.getLog(ConfigMapPropertySourceLocator.class);
    protected final ConfigMapConfigProperties properties;

    public ConfigMapPropertySourceLocator(ConfigMapConfigProperties properties) {
        this.properties = properties;
    }

    protected abstract MapPropertySource getMapPropertySource(String var1, ConfigMapConfigProperties.NormalizedSource var2, String var3, ConfigurableEnvironment var4);

    @Retryable(interceptor="kubernetesConfigRetryInterceptor")
    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            CompositePropertySource composite = new CompositePropertySource("composite-configmap");
            if (this.properties.isEnableApi()) {
                LinkedHashSet<ConfigMapConfigProperties.NormalizedSource> sources = new LinkedHashSet<ConfigMapConfigProperties.NormalizedSource>(this.properties.determineSources());
                LOG.debug((Object)("Config Map normalized sources : " + sources));
                sources.forEach(s -> composite.addFirstPropertySource((PropertySource)this.getMapPropertySourceForSingleConfigMap(env, (ConfigMapConfigProperties.NormalizedSource)s)));
            }
            this.addPropertySourcesFromPaths(environment, composite);
            return composite;
        }
        return null;
    }

    @Retryable(interceptor="kubernetesConfigRetryInterceptor")
    public Collection<PropertySource<?>> locateCollection(Environment environment) {
        return super.locateCollection(environment);
    }

    private MapPropertySource getMapPropertySourceForSingleConfigMap(ConfigurableEnvironment environment, ConfigMapConfigProperties.NormalizedSource normalizedSource) {
        String configurationTarget = this.properties.getConfigurationTarget();
        String applicationName = ConfigUtils.getApplicationName((Environment)environment, normalizedSource.getName(), configurationTarget);
        return this.getMapPropertySource(applicationName, normalizedSource, configurationTarget, environment);
    }

    private void addPropertySourcesFromPaths(Environment environment, CompositePropertySource composite) {
        LinkedHashSet<String> uniquePaths = new LinkedHashSet<String>(this.properties.getPaths());
        uniquePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> {
            boolean exists = Files.exists(p, new LinkOption[0]);
            if (!exists) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it does not exist on the file system"));
            }
            return exists;
        }).filter(p -> {
            boolean regular = Files.isRegularFile(p, new LinkOption[0]);
            if (!regular) {
                LOG.warn((Object)("Configured input path: " + p + " will be ignored because it is not a regular file"));
            }
            return regular;
        }).collect(Collectors.toList()).forEach(p -> {
            try {
                String content = new String(Files.readAllBytes(p)).trim();
                String filename = p.toAbsolutePath().toString().toLowerCase();
                if (filename.endsWith(".properties")) {
                    this.addPropertySourceIfNeeded(c -> PropertySourceUtils.PROPERTIES_TO_MAP.apply(PropertySourceUtils.KEY_VALUE_TO_PROPERTIES.apply((String)c)), content, filename, composite);
                } else if (filename.endsWith(".yml") || filename.endsWith(".yaml")) {
                    this.addPropertySourceIfNeeded(c -> PropertySourceUtils.PROPERTIES_TO_MAP.apply(PropertySourceUtils.yamlParserGenerator(environment).apply((String)c)), content, filename, composite);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading input file", (Throwable)e);
            }
        });
    }

    private void addPropertySourceIfNeeded(Function<String, Map<String, Object>> contentToMapFunction, String content, String name, CompositePropertySource composite) {
        HashMap<String, Object> map = new HashMap<String, Object>(contentToMapFunction.apply(content));
        if (map.isEmpty()) {
            LOG.warn((Object)("Property source: " + name + "will be ignored because no properties could be found"));
        } else {
            composite.addFirstPropertySource((PropertySource)new MapPropertySource(name, map));
        }
    }
}

