/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.config.AbstractConfigProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.config")
public class ConfigMapConfigProperties
extends AbstractConfigProperties {
    private static final String TARGET = "Config Map";
    private boolean enableApi = true;
    private List<String> paths = Collections.emptyList();
    private List<Source> sources = Collections.emptyList();

    public boolean isEnableApi() {
        return this.enableApi;
    }

    public void setEnableApi(boolean enableApi) {
        this.enableApi = enableApi;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<NormalizedSource> determineSources() {
        if (this.sources.isEmpty()) {
            return Collections.singletonList(new NormalizedSource(this.name, this.namespace));
        }
        return this.sources.stream().map(s -> s.normalize(this.name, this.namespace)).collect(Collectors.toList());
    }

    @Override
    public String getConfigurationTarget() {
        return TARGET;
    }

    public static class NormalizedSource {
        private final String name;
        private final String namespace;

        NormalizedSource(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }

    public static class Source {
        private String name;
        private String namespace;

        public Source() {
        }

        public Source(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean isEmpty() {
            return StringUtils.isEmpty((Object)this.name) && StringUtils.isEmpty((Object)this.namespace);
        }

        public NormalizedSource normalize(String defaultName, String defaultNamespace) {
            String normalizedName = StringUtils.isEmpty((Object)this.name) ? defaultName : this.name;
            String normalizedNamespace = StringUtils.isEmpty((Object)this.namespace) ? defaultNamespace : this.namespace;
            return new NormalizedSource(normalizedName, normalizedNamespace);
        }
    }
}

