/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.leader.election;

import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.openapi.ApiException;
import java.util.HashMap;
import java.util.Optional;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.core.log.LogAccessor;

final class KubernetesClientLeaderElectionInfoContributor
implements InfoContributor {
    private static final LogAccessor LOG = new LogAccessor(KubernetesClientLeaderElectionInfoContributor.class);
    private final String candidateIdentity;
    private final LeaderElectionConfig leaderElectionConfig;

    KubernetesClientLeaderElectionInfoContributor(String candidateIdentity, LeaderElectionConfig leaderElectionConfig) {
        this.candidateIdentity = candidateIdentity;
        this.leaderElectionConfig = leaderElectionConfig;
    }

    public void contribute(Info.Builder builder) {
        HashMap details = new HashMap();
        try {
            Optional.ofNullable(this.leaderElectionConfig.getLock().get()).ifPresentOrElse(leaderRecord -> {
                boolean isLeader = this.candidateIdentity.equals(leaderRecord.getHolderIdentity());
                details.put("leaderId", this.candidateIdentity);
                details.put("isLeader", isLeader);
            }, () -> details.put("leaderId", "Unknown"));
        }
        catch (ApiException e) {
            LOG.error((Throwable)e, (CharSequence)"error in leader election info contributor");
        }
        builder.withDetail("leaderElection", details);
    }
}

