/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceSpec;
import io.kubernetes.client.util.wait.Wait;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.ServiceMetadata;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

final class KubernetesClientDiscoveryClientUtils {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientDiscoveryClientUtils.class));

    private KubernetesClientDiscoveryClientUtils() {
    }

    static boolean matchesServiceLabels(V1Service service, KubernetesDiscoveryProperties properties) {
        Map propertiesServiceLabels = properties.serviceLabels();
        Map serviceLabels = Optional.ofNullable(service.getMetadata()).map(V1ObjectMeta::getLabels).orElse(Map.of());
        if (propertiesServiceLabels.isEmpty()) {
            LOG.debug(() -> "service labels from properties are empty, service with name : '" + service.getMetadata().getName() + "' will match");
            return true;
        }
        if (serviceLabels.isEmpty()) {
            LOG.debug(() -> "service with name : '" + service.getMetadata().getName() + "' does not have labels");
            return false;
        }
        LOG.debug(() -> "Service labels from properties : " + String.valueOf(propertiesServiceLabels));
        LOG.debug(() -> "Service labels from service : " + String.valueOf(serviceLabels));
        return serviceLabels.entrySet().containsAll(propertiesServiceLabels.entrySet());
    }

    static void postConstruct(List<SharedInformerFactory> sharedInformerFactories, KubernetesDiscoveryProperties properties, Supplier<Boolean> informersReadyFunc, List<Lister<V1Service>> serviceListers) {
        sharedInformerFactories.forEach(SharedInformerFactory::startAllRegisteredInformers);
        if (!Wait.poll((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(properties.cacheLoadingTimeoutSeconds()), () -> {
            LOG.info(() -> "Waiting for the cache of informers to be fully loaded..");
            return (Boolean)informersReadyFunc.get();
        })) {
            if (properties.waitCacheReady()) {
                throw new IllegalStateException("Timeout waiting for informers cache to be ready, is the kubernetes service up?");
            }
            LOG.warn(() -> "Timeout waiting for informers cache to be ready, ignoring the failure because waitForInformerCacheReady property is false");
        } else {
            LOG.info(() -> "Cache fully loaded (total " + serviceListers.stream().mapToLong(x -> x.list().size()).sum() + " services), discovery client is now available");
        }
    }

    static ServiceMetadata serviceMetadata(V1Service service) {
        V1ObjectMeta metadata = service.getMetadata();
        V1ServiceSpec serviceSpec = service.getSpec();
        return new ServiceMetadata(metadata.getName(), metadata.getNamespace(), serviceSpec.getType(), metadata.getLabels(), metadata.getAnnotations());
    }

    static Map<String, Integer> endpointSubsetsPortData(List<V1EndpointSubset> endpointSubsets) {
        return endpointSubsets.stream().flatMap(endpointSubset -> Optional.ofNullable(endpointSubset.getPorts()).orElse(List.of()).stream()).collect(Collectors.toMap(endpointPort -> StringUtils.hasText((String)endpointPort.getName()) ? endpointPort.getName() : "<unset>", CoreV1EndpointPort::getPort));
    }

    static List<V1EndpointAddress> addresses(V1EndpointSubset endpointSubset, KubernetesDiscoveryProperties properties) {
        List addresses = Optional.ofNullable(endpointSubset.getAddresses()).map(ArrayList::new).orElse(new ArrayList());
        if (properties.includeNotReadyAddresses()) {
            List notReadyAddresses = endpointSubset.getNotReadyAddresses();
            if (CollectionUtils.isEmpty((Collection)notReadyAddresses)) {
                return addresses;
            }
            addresses.addAll(notReadyAddresses);
        }
        return addresses;
    }
}

