/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerDiscoveryClient;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

abstract class KubernetesClientReactiveAbstractInformerDiscoveryClient
implements ReactiveDiscoveryClient {
    private final KubernetesClientInformerDiscoveryClient kubernetesDiscoveryClient;

    KubernetesClientReactiveAbstractInformerDiscoveryClient(KubernetesClientInformerDiscoveryClient kubernetesDiscoveryClient) {
        this.kubernetesDiscoveryClient = kubernetesDiscoveryClient;
    }

    public abstract String description();

    public Flux<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getInstances(serviceId))).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getServices())).subscribeOn(Schedulers.boundedElastic());
    }

    public int getOrder() {
        return this.kubernetesDiscoveryClient.getOrder();
    }
}

