/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.cloud.kubernetes.commons.discovery.InstanceIdHostPodName;

final class KubernetesClientInstanceIdHostPodNameSupplier
implements Supplier<InstanceIdHostPodName> {
    private final V1EndpointAddress endpointAddress;
    private final V1Service service;

    private KubernetesClientInstanceIdHostPodNameSupplier(V1EndpointAddress endpointAddress, V1Service service) {
        this.endpointAddress = endpointAddress;
        this.service = service;
    }

    @Override
    public InstanceIdHostPodName get() {
        return new InstanceIdHostPodName(this.instanceId(), this.host(), this.podName());
    }

    static KubernetesClientInstanceIdHostPodNameSupplier nonExternalName(V1EndpointAddress endpointAddress, V1Service service) {
        return new KubernetesClientInstanceIdHostPodNameSupplier(endpointAddress, service);
    }

    static KubernetesClientInstanceIdHostPodNameSupplier externalName(V1Service service) {
        return new KubernetesClientInstanceIdHostPodNameSupplier(null, service);
    }

    private String instanceId() {
        return Optional.ofNullable(this.endpointAddress).map(V1EndpointAddress::getTargetRef).map(V1ObjectReference::getUid).orElseGet(() -> this.service.getMetadata().getUid());
    }

    private String host() {
        return Optional.ofNullable(this.endpointAddress).map(V1EndpointAddress::getIp).orElseGet(() -> this.service.getSpec().getExternalName());
    }

    private String podName() {
        return Optional.ofNullable(this.endpointAddress).map(V1EndpointAddress::getTargetRef).filter(objectReference -> "Pod".equals(objectReference.getKind())).map(V1ObjectReference::getName).orElse(null);
    }
}

