/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.ReactiveCommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.composite.reactive.ReactiveCompositeDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientCacheableInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientDiscoveryClientSpelAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableReactiveEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesReactiveDiscovery;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesReactiveDiscovery
@AutoConfigureBefore(value={SimpleReactiveDiscoveryClientAutoConfiguration.class, ReactiveCommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={ReactiveCompositeDiscoveryClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, KubernetesClientDiscoveryClientSpelAutoConfiguration.class})
final class KubernetesClientInformerReactiveDiscoveryClientAutoConfiguration {
    KubernetesClientInformerReactiveDiscoveryClientAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveDisabled
    KubernetesClientInformerReactiveDiscoveryClient kubernetesClientInformerReactiveDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties, CoreV1Api coreV1Api, Predicate<V1Service> predicate) {
        KubernetesClientInformerDiscoveryClient blockingClient = new KubernetesClientInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, properties, coreV1Api, predicate);
        blockingClient.afterPropertiesSet();
        return new KubernetesClientInformerReactiveDiscoveryClient(blockingClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableReactiveEnabled
    KubernetesClientCacheableInformerReactiveDiscoveryClient kubernetesClientCacheableInformerReactiveDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties, CoreV1Api coreV1Api, Predicate<V1Service> predicate) {
        KubernetesClientInformerDiscoveryClient blockingClient = new KubernetesClientInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, properties, coreV1Api, predicate);
        blockingClient.afterPropertiesSet();
        return new KubernetesClientCacheableInformerReactiveDiscoveryClient(blockingClient);
    }
}

