/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientCacheableInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientDiscoveryClientSpelAutoConfiguration;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesClientInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryClientHealthIndicatorInitializer;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryPropertiesAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingDisabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnDiscoveryCacheableBlockingEnabled;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscovery;
import org.springframework.cloud.kubernetes.commons.discovery.conditionals.ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.log.LogAccessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSpringCloudKubernetesBlockingDiscovery
@AutoConfigureBefore(value={SimpleDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class})
@AutoConfigureAfter(value={KubernetesClientAutoConfiguration.class, KubernetesDiscoveryPropertiesAutoConfiguration.class, KubernetesClientDiscoveryClientSpelAutoConfiguration.class})
final class KubernetesClientInformerDiscoveryClientAutoConfiguration {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientInformerDiscoveryClientAutoConfiguration.class));

    KubernetesClientInformerDiscoveryClientAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingDisabled
    KubernetesClientInformerDiscoveryClient kubernetesClientInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties, CoreV1Api coreV1Api, Predicate<V1Service> predicate) {
        return new KubernetesClientInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, properties, coreV1Api, predicate);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnDiscoveryCacheableBlockingEnabled
    KubernetesClientCacheableInformerDiscoveryClient kubernetesClientCacheableInformerDiscoveryClient(List<SharedInformerFactory> sharedInformerFactories, List<Lister<V1Service>> serviceListers, List<Lister<V1Endpoints>> endpointsListers, List<SharedInformer<V1Service>> serviceInformers, List<SharedInformer<V1Endpoints>> endpointsInformers, KubernetesDiscoveryProperties properties, CoreV1Api coreV1Api, Predicate<V1Service> predicate) {
        return new KubernetesClientCacheableInformerDiscoveryClient(sharedInformerFactories, serviceListers, endpointsListers, serviceInformers, endpointsInformers, properties, coreV1Api, predicate);
    }

    @Bean
    @ConditionalOnSpringCloudKubernetesBlockingDiscoveryHealthInitializer
    KubernetesDiscoveryClientHealthIndicatorInitializer indicatorInitializer(ApplicationEventPublisher applicationEventPublisher, PodUtils<?> podUtils) {
        LOG.debug(() -> "Will publish InstanceRegisteredEvent from blocking implementation");
        return new KubernetesDiscoveryClientHealthIndicatorInitializer(podUtils, applicationEventPublisher);
    }
}

