/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.catalog;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.discovery.catalog.KubernetesCatalogWatchContext;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.core.log.LogAccessor;

final class KubernetesEndpointsCatalogWatch
implements Function<KubernetesCatalogWatchContext, List<EndpointNameAndNamespace>> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesEndpointsCatalogWatch.class));

    KubernetesEndpointsCatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(KubernetesCatalogWatchContext context) {
        List<V1Endpoints> endpoints;
        CoreV1Api coreV1Api = context.coreV1Api();
        if (context.properties().allNamespaces()) {
            LOG.debug(() -> "discovering endpoints in all namespaces");
            endpoints = this.endpoints(coreV1Api, context.properties().serviceLabels());
        } else if (!context.properties().namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoints in " + context.properties().namespaces());
            ArrayList<V1Endpoints> inner = new ArrayList<V1Endpoints>(context.properties().namespaces().size());
            context.properties().namespaces().forEach(namespace -> inner.addAll(this.namespacedEndpoints(coreV1Api, (String)namespace, context.properties().serviceLabels())));
            endpoints = inner;
        } else {
            String namespace2 = KubernetesClientUtils.getApplicationNamespace(null, (String)"catalog-watch", (KubernetesNamespaceProvider)context.namespaceProvider());
            LOG.debug(() -> "discovering endpoints in namespace : " + namespace2);
            endpoints = this.namespacedEndpoints(coreV1Api, namespace2, context.properties().serviceLabels());
        }
        return this.generateState(endpoints);
    }

    List<EndpointNameAndNamespace> generateState(List<V1Endpoints> endpoints) {
        Stream<V1ObjectReference> references = endpoints.stream().map(V1Endpoints::getSubsets).filter(Objects::nonNull).flatMap(Collection::stream).map(V1EndpointSubset::getAddresses).filter(Objects::nonNull).flatMap(Collection::stream).map(V1EndpointAddress::getTargetRef);
        return KubernetesCatalogWatchContext.state(references);
    }

    private List<V1Endpoints> endpoints(CoreV1Api client, Map<String, String> labels) {
        try {
            return client.listEndpointsForAllNamespaces().labelSelector(KubernetesCatalogWatchContext.labelSelector(labels)).execute().getItems();
        }
        catch (ApiException e) {
            LOG.warn((Throwable)e, () -> "can not list endpoints in all namespaces");
            return Collections.emptyList();
        }
    }

    private List<V1Endpoints> namespacedEndpoints(CoreV1Api client, String namespace, Map<String, String> labels) {
        try {
            return client.listNamespacedEndpoints(namespace).labelSelector(KubernetesCatalogWatchContext.labelSelector(labels)).execute().getItems();
        }
        catch (ApiException e) {
            LOG.warn((Throwable)e, () -> "can not list endpoints in namespace " + namespace);
            return Collections.emptyList();
        }
    }
}

