/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class ConditionalOnSelectiveNamespacesMissing
implements ConfigurationCondition {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConditionalOnSelectiveNamespacesMissing.class));

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Set selectiveNamespaces = (Set)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.kubernetes.discovery.namespaces", Bindable.setOf(String.class)).orElse(Set.of());
        boolean selectiveNamespacesMissing = selectiveNamespaces.isEmpty();
        if (selectiveNamespacesMissing) {
            LOG.debug(() -> "selective namespaces not present");
        } else {
            LOG.debug(() -> "found selective namespaces : " + selectiveNamespaces.stream().sorted().toList());
        }
        return selectiveNamespacesMissing;
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN;
    }
}

