/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.reactive;

import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class KubernetesInformerReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final KubernetesInformerDiscoveryClient kubernetesDiscoveryClient;

    @Deprecated(forRemoval=true)
    public KubernetesInformerReactiveDiscoveryClient(KubernetesNamespaceProvider kubernetesNamespaceProvider, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.kubernetesDiscoveryClient = new KubernetesInformerDiscoveryClient(kubernetesNamespaceProvider.getNamespace(), sharedInformerFactory, serviceLister, endpointsLister, serviceInformer, endpointsInformer, properties);
    }

    KubernetesInformerReactiveDiscoveryClient(KubernetesInformerDiscoveryClient kubernetesDiscoveryClient) {
        this.kubernetesDiscoveryClient = kubernetesDiscoveryClient;
    }

    public String description() {
        return "Kubernetes Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        Objects.requireNonNull(serviceId, "serviceId must be provided");
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getInstances(serviceId))).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Flux.fromIterable(this.kubernetesDiscoveryClient.getServices())).subscribeOn(Schedulers.boundedElastic());
    }
}

