/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.catalog;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.DiscoveryV1Api;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1EndpointSlice;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.discovery.catalog.KubernetesCatalogWatchContext;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.core.log.LogAccessor;

final class KubernetesEndpointSlicesCatalogWatch
implements Function<KubernetesCatalogWatchContext, List<EndpointNameAndNamespace>> {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesEndpointSlicesCatalogWatch.class));

    KubernetesEndpointSlicesCatalogWatch() {
    }

    @Override
    public List<EndpointNameAndNamespace> apply(KubernetesCatalogWatchContext context) {
        List<V1EndpointSlice> endpointSlices;
        DiscoveryV1Api api = new DiscoveryV1Api(context.apiClient());
        if (context.properties().allNamespaces()) {
            LOG.debug(() -> "discovering endpoint slices in all namespaces");
            endpointSlices = this.endpointSlices(api, context.properties().serviceLabels());
        } else if (!context.properties().namespaces().isEmpty()) {
            LOG.debug(() -> "discovering endpoint slices in " + context.properties().namespaces());
            ArrayList<V1EndpointSlice> inner = new ArrayList<V1EndpointSlice>(context.properties().namespaces().size());
            context.properties().namespaces().forEach(namespace -> inner.addAll(this.namespacedEndpointSlices(api, (String)namespace, context.properties().serviceLabels())));
            endpointSlices = inner;
        } else {
            String namespace2 = KubernetesClientUtils.getApplicationNamespace(null, (String)"catalog-watch", (KubernetesNamespaceProvider)context.namespaceProvider());
            LOG.debug(() -> "discovering endpoint slices in namespace : " + namespace2);
            endpointSlices = this.namespacedEndpointSlices(api, namespace2, context.properties().serviceLabels());
        }
        Stream<V1ObjectReference> references = endpointSlices.stream().map(V1EndpointSlice::getEndpoints).flatMap(Collection::stream).map(V1Endpoint::getTargetRef);
        return KubernetesCatalogWatchContext.state(references);
    }

    private List<V1EndpointSlice> endpointSlices(DiscoveryV1Api api, Map<String, String> labels) {
        try {
            return api.listEndpointSliceForAllNamespaces(null, null, null, KubernetesCatalogWatchContext.labelSelector(labels), null, null, null, null, null, null, null).getItems();
        }
        catch (ApiException e) {
            LOG.warn((Throwable)e, () -> "can not list endpoint slices in all namespaces");
            return Collections.emptyList();
        }
    }

    private List<V1EndpointSlice> namespacedEndpointSlices(DiscoveryV1Api api, String namespace, Map<String, String> labels) {
        try {
            return api.listNamespacedEndpointSlice(namespace, null, null, null, null, KubernetesCatalogWatchContext.labelSelector(labels), null, null, null, null, null, null).getItems();
        }
        catch (ApiException e) {
            LOG.warn((Throwable)e, () -> "can not list endpoint slices in namespace " + namespace);
            return Collections.emptyList();
        }
    }
}

