/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1Service;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.kubernetes.commons.discovery.DefaultKubernetesServiceInstance;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class KubernetesInformerDiscoveryClient
implements DiscoveryClient,
InitializingBean {
    private static final Log log = LogFactory.getLog(KubernetesInformerDiscoveryClient.class);
    private static final String PRIMARY_PORT_NAME_LABEL_KEY = "primary-port-name";
    private static final String SECURED_KEY = "secured";
    private final SharedInformerFactory sharedInformerFactory;
    private final Lister<V1Service> serviceLister;
    private final Supplier<Boolean> informersReadyFunc;
    private final Lister<V1Endpoints> endpointsLister;
    private final KubernetesDiscoveryProperties properties;
    private final String namespace;

    public KubernetesInformerDiscoveryClient(String namespace, SharedInformerFactory sharedInformerFactory, Lister<V1Service> serviceLister, Lister<V1Endpoints> endpointsLister, SharedInformer<V1Service> serviceInformer, SharedInformer<V1Endpoints> endpointsInformer, KubernetesDiscoveryProperties properties) {
        this.namespace = namespace;
        this.sharedInformerFactory = sharedInformerFactory;
        this.serviceLister = serviceLister;
        this.endpointsLister = endpointsLister;
        this.informersReadyFunc = () -> serviceInformer.hasSynced() && endpointsInformer.hasSynced();
        this.properties = properties;
    }

    public String description() {
        return "Kubernetes Client Discovery";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        List<V1Service> services;
        Assert.notNull((Object)serviceId, (String)"[Assertion failed] - the object argument must not be null");
        if (!StringUtils.hasText((String)this.namespace) && !this.properties.allNamespaces()) {
            log.warn((Object)"Namespace is null or empty, this may cause issues looking up services");
        }
        List<V1Service> list = services = this.properties.allNamespaces() ? this.serviceLister.list().stream().filter(svc -> serviceId.equals(svc.getMetadata().getName())).toList() : List.of((V1Service)this.serviceLister.namespace(this.namespace).get(serviceId));
        if (services.size() == 0 || !services.stream().anyMatch(this::matchServiceLabels)) {
            return new ArrayList<ServiceInstance>();
        }
        return services.stream().flatMap(s -> this.getServiceInstanceDetails((V1Service)s, serviceId)).toList();
    }

    private Stream<ServiceInstance> getServiceInstanceDetails(V1Service service, String serviceId) {
        V1Endpoints ep;
        HashMap svcMetadata = new HashMap();
        if (this.properties.metadata() != null) {
            if (this.properties.metadata().addLabels() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
                String labelPrefix = this.properties.metadata().labelsPrefix() != null ? this.properties.metadata().labelsPrefix() : "";
                service.getMetadata().getLabels().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(labelPrefix)).forEach(e -> svcMetadata.put((String)e.getKey(), (String)e.getValue()));
            }
            if (this.properties.metadata().addAnnotations() && service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
                String annotationPrefix = this.properties.metadata().annotationsPrefix() != null ? this.properties.metadata().annotationsPrefix() : "";
                service.getMetadata().getAnnotations().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(annotationPrefix)).forEach(e -> svcMetadata.put((String)e.getKey(), (String)e.getValue()));
            }
        }
        if ((ep = (V1Endpoints)this.endpointsLister.namespace(service.getMetadata().getNamespace()).get(service.getMetadata().getName())) == null || ep.getSubsets() == null) {
            return Stream.empty();
        }
        Optional<String> discoveredPrimaryPortName = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            discoveredPrimaryPortName = Optional.ofNullable((String)service.getMetadata().getLabels().get(PRIMARY_PORT_NAME_LABEL_KEY));
        }
        String primaryPortName = discoveredPrimaryPortName.orElse(this.properties.primaryPortName());
        boolean secured = KubernetesInformerDiscoveryClient.isSecured(service);
        return ep.getSubsets().stream().filter(subset -> subset.getPorts() != null && subset.getPorts().size() > 0).flatMap(subset -> {
            ArrayList addresses;
            HashMap metadata = new HashMap(svcMetadata);
            List endpointPorts = subset.getPorts();
            if (this.properties.metadata() != null && this.properties.metadata().addPorts()) {
                endpointPorts.forEach(p -> metadata.put(StringUtils.hasText((String)p.getName()) ? p.getName() : "<unset>", Integer.toString(p.getPort())));
            }
            if ((addresses = subset.getAddresses()) == null) {
                addresses = new ArrayList();
            }
            if (this.properties.includeNotReadyAddresses() && !CollectionUtils.isEmpty((Collection)subset.getNotReadyAddresses())) {
                addresses.addAll(subset.getNotReadyAddresses());
            }
            int port = this.findEndpointPort(endpointPorts, primaryPortName, serviceId);
            return addresses.stream().map(addr -> new DefaultKubernetesServiceInstance(addr.getTargetRef() != null ? addr.getTargetRef().getUid() : "", serviceId, addr.getIp(), port, metadata, secured, service.getMetadata().getNamespace(), null));
        });
    }

    private static boolean isSecured(V1Service service) {
        Optional<String> securedOpt = Optional.empty();
        if (service.getMetadata() != null && service.getMetadata().getAnnotations() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getAnnotations().get(SECURED_KEY));
        }
        if (!securedOpt.isPresent() && service.getMetadata() != null && service.getMetadata().getLabels() != null) {
            securedOpt = Optional.ofNullable((String)service.getMetadata().getLabels().get(SECURED_KEY));
        }
        return Boolean.parseBoolean(securedOpt.orElse("false"));
    }

    private int findEndpointPort(List<CoreV1EndpointPort> endpointPorts, String primaryPortName, String serviceId) {
        if (endpointPorts.size() == 1) {
            return endpointPorts.get(0).getPort();
        }
        Map<String, Integer> ports = endpointPorts.stream().filter(p -> StringUtils.hasText((String)p.getName())).collect(Collectors.toMap(CoreV1EndpointPort::getName, CoreV1EndpointPort::getPort));
        int discoveredPort = ports.getOrDefault(primaryPortName, ports.getOrDefault("https", ports.getOrDefault("http", -1)));
        if (discoveredPort == -1) {
            if (StringUtils.hasText((String)primaryPortName)) {
                log.warn((Object)("Could not find a port named '" + primaryPortName + "', 'https', or 'http' for service '" + serviceId + "'."));
            } else {
                log.warn((Object)("Could not find a port named 'https' or 'http' for service '" + serviceId + "'."));
            }
            log.warn((Object)"Make sure that either the primary-port-name label has been added to the service, or that spring.cloud.kubernetes.discovery.primary-port-name has been configured.");
            log.warn((Object)"Alternatively name the primary port 'https' or 'http'");
            log.warn((Object)"An incorrect configuration may result in non-deterministic behaviour.");
            discoveredPort = endpointPorts.get(0).getPort();
        }
        return discoveredPort;
    }

    public List<String> getServices() {
        List services = this.properties.allNamespaces() ? this.serviceLister.list() : this.serviceLister.namespace(this.namespace).list();
        return services.stream().filter(this::matchServiceLabels).map(s -> s.getMetadata().getName()).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        this.sharedInformerFactory.startAllRegisteredInformers();
        if (!Wait.poll((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(this.properties.cacheLoadingTimeoutSeconds()), () -> {
            log.info((Object)"Waiting for the cache of informers to be fully loaded..");
            return this.informersReadyFunc.get();
        })) {
            if (this.properties.waitCacheReady()) {
                throw new IllegalStateException("Timeout waiting for informers cache to be ready, is the kubernetes service up?");
            }
            log.warn((Object)"Timeout waiting for informers cache to be ready, ignoring the failure because waitForInformerCacheReady property is false");
        }
        log.info((Object)("Cache fully loaded (total " + this.serviceLister.list().size() + " services) , discovery client is now available"));
    }

    private boolean matchServiceLabels(V1Service service) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Kubernetes Service Label Properties:");
            if (this.properties.serviceLabels() != null) {
                this.properties.serviceLabels().forEach((key, value) -> log.debug((Object)(key + ":" + value)));
            }
            log.debug((Object)("Service " + service.getMetadata().getName() + " labels:"));
            if (service.getMetadata() != null && service.getMetadata().getLabels() != null) {
                service.getMetadata().getLabels().forEach((key, value) -> log.debug((Object)(key + ":" + value)));
            }
        }
        if (service.getMetadata() == null) {
            return false;
        }
        if (this.properties.serviceLabels() == null || this.properties.serviceLabels().isEmpty()) {
            return true;
        }
        return this.properties.serviceLabels().keySet().stream().allMatch(k -> service.getMetadata().getLabels() != null && service.getMetadata().getLabels().containsKey(k) && ((String)service.getMetadata().getLabels().get(k)).equals(this.properties.serviceLabels().get(k)));
    }
}

