/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import java.util.EnumMap;
import java.util.Optional;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigContext;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientContextToSourceData;
import org.springframework.cloud.kubernetes.client.config.LabeledSecretContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.client.config.NamedSecretContextToSourceDataProvider;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSourceType;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.cloud.kubernetes.commons.config.SourceData;

public class KubernetesClientSecretsPropertySource
extends SecretsPropertySource {
    private static final EnumMap<NormalizedSourceType, KubernetesClientContextToSourceData> STRATEGIES = new EnumMap(NormalizedSourceType.class);

    public KubernetesClientSecretsPropertySource(KubernetesClientConfigContext context) {
        super(KubernetesClientSecretsPropertySource.getSourceData(context));
    }

    private static SourceData getSourceData(KubernetesClientConfigContext context) {
        NormalizedSourceType type = context.normalizedSource().type();
        return Optional.ofNullable(STRATEGIES.get(type)).map(x -> (SourceData)x.apply(context)).orElseThrow(() -> new IllegalArgumentException("no strategy found for : " + String.valueOf(type)));
    }

    private static KubernetesClientContextToSourceData namedSecret() {
        return new NamedSecretContextToSourceDataProvider().get();
    }

    private static KubernetesClientContextToSourceData labeledSecret() {
        return new LabeledSecretContextToSourceDataProvider().get();
    }

    static {
        STRATEGIES.put(NormalizedSourceType.NAMED_SECRET, KubernetesClientSecretsPropertySource.namedSecret());
        STRATEGIES.put(NormalizedSourceType.LABELED_SECRET, KubernetesClientSecretsPropertySource.labeledSecret());
    }
}

