/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigDataRetryableSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.configdata.ConfigDataPropertiesHolder;
import org.springframework.cloud.kubernetes.commons.configdata.KubernetesConfigDataLocationResolver;

public class KubernetesClientConfigDataLocationResolver
extends KubernetesConfigDataLocationResolver {
    protected void registerBeans(ConfigDataLocationResolverContext resolverContext, ConfigDataPropertiesHolder properties, KubernetesNamespaceProvider namespaceProvider) {
        KubernetesClientProperties kubernetesClientProperties = properties.clientProperties();
        ConfigMapConfigProperties configMapProperties = properties.configMapProperties();
        SecretsConfigProperties secretsProperties = properties.secretsProperties();
        ConfigurableBootstrapContext bootstrapContext = resolverContext.getBootstrapContext();
        CoreV1Api coreV1Api = this.registerClientAndCoreV1Api(bootstrapContext, kubernetesClientProperties);
        if (configMapProperties != null && configMapProperties.enabled()) {
            KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator = new KubernetesClientConfigMapPropertySourceLocator(coreV1Api, configMapProperties, namespaceProvider);
            if (this.isRetryEnabledForConfigMap(configMapProperties)) {
                configMapPropertySourceLocator = new ConfigDataRetryableConfigMapPropertySourceLocator((ConfigMapPropertySourceLocator)configMapPropertySourceLocator, configMapProperties);
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, ConfigMapPropertySourceLocator.class, (Object)((Object)configMapPropertySourceLocator), (String)"configDataConfigMapPropertySourceLocator");
        }
        if (secretsProperties != null && secretsProperties.enabled()) {
            KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator = new KubernetesClientSecretsPropertySourceLocator(coreV1Api, namespaceProvider, secretsProperties);
            if (this.isRetryEnabledForSecrets(secretsProperties)) {
                secretsPropertySourceLocator = new ConfigDataRetryableSecretsPropertySourceLocator((SecretsPropertySourceLocator)secretsPropertySourceLocator, secretsProperties);
            }
            ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, SecretsPropertySourceLocator.class, (Object)((Object)secretsPropertySourceLocator), (String)"configDataSecretsPropertySourceLocator");
        }
    }

    private CoreV1Api registerClientAndCoreV1Api(ConfigurableBootstrapContext bootstrapContext, KubernetesClientProperties kubernetesClientProperties) {
        ApiClient apiClient = KubernetesClientUtils.kubernetesApiClient();
        apiClient.setUserAgent(kubernetesClientProperties.userAgent());
        ConfigUtils.registerSingle((ConfigurableBootstrapContext)bootstrapContext, ApiClient.class, (Object)apiClient, (String)"configDataApiClient");
        CoreV1Api coreV1Api = new CoreV1Api(apiClient);
        bootstrapContext.registerIfAbsent(CoreV1Api.class, BootstrapRegistry.InstanceSupplier.of((Object)coreV1Api));
        return coreV1Api;
    }
}

