/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.core.env.Environment;

public final class KubernetesClientConfigUtils {
    private static final Log LOG = LogFactory.getLog(KubernetesClientConfigUtils.class);
    private static final boolean DECODE = Boolean.FALSE;

    private KubernetesClientConfigUtils() {
    }

    public static Set<String> namespaces(KubernetesNamespaceProvider provider, ConfigReloadProperties properties, String target) {
        Set<String> namespaces = properties.namespaces();
        if (namespaces.isEmpty()) {
            namespaces = Set.of(KubernetesClientUtils.getApplicationNamespace(null, (String)target, (KubernetesNamespaceProvider)provider));
        }
        LOG.debug((Object)("informer namespaces : " + namespaces));
        return namespaces;
    }

    static MultipleSourcesContainer secretsDataByLabels(CoreV1Api client, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<V1Secret> secrets = KubernetesClientConfigUtils.secretsSearch(client, namespace);
        if (ConfigUtils.noSources(secrets, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = KubernetesClientConfigUtils.strippedSecrets(secrets);
        return ConfigUtils.processLabeledData(strippedSources, (Environment)environment, labels, (String)namespace, profiles, (boolean)DECODE);
    }

    static MultipleSourcesContainer configMapsDataByLabels(CoreV1Api client, String namespace, Map<String, String> labels, Environment environment, Set<String> profiles) {
        List<V1ConfigMap> configMaps = KubernetesClientConfigUtils.configMapsSearch(client, namespace);
        if (ConfigUtils.noSources(configMaps, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = KubernetesClientConfigUtils.strippedConfigMaps(configMaps);
        return ConfigUtils.processLabeledData(strippedSources, (Environment)environment, labels, (String)namespace, profiles, (boolean)DECODE);
    }

    static MultipleSourcesContainer secretsDataByName(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<V1Secret> secrets = KubernetesClientConfigUtils.secretsSearch(client, namespace);
        if (ConfigUtils.noSources(secrets, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = KubernetesClientConfigUtils.strippedSecrets(secrets);
        return ConfigUtils.processNamedData(strippedSources, (Environment)environment, sourceNames, (String)namespace, (boolean)DECODE);
    }

    static MultipleSourcesContainer configMapsDataByName(CoreV1Api client, String namespace, LinkedHashSet<String> sourceNames, Environment environment) {
        List<V1ConfigMap> configMaps = KubernetesClientConfigUtils.configMapsSearch(client, namespace);
        if (ConfigUtils.noSources(configMaps, (String)namespace)) {
            return MultipleSourcesContainer.empty();
        }
        List<StrippedSourceContainer> strippedSources = KubernetesClientConfigUtils.strippedConfigMaps(configMaps);
        return ConfigUtils.processNamedData(strippedSources, (Environment)environment, sourceNames, (String)namespace, (boolean)DECODE);
    }

    private static List<V1Secret> secretsSearch(CoreV1Api client, String namespace) {
        LOG.debug((Object)("Loading all secrets in namespace '" + namespace + "'"));
        try {
            return client.listNamespacedSecret(namespace, null, null, null, null, null, null, null, null, null, null).getItems();
        }
        catch (ApiException apiException) {
            throw new RuntimeException(apiException.getResponseBody(), apiException);
        }
    }

    private static List<V1ConfigMap> configMapsSearch(CoreV1Api client, String namespace) {
        LOG.debug((Object)("Loading all config maps in namespace '" + namespace + "'"));
        try {
            return client.listNamespacedConfigMap(namespace, null, null, null, null, null, null, null, null, null, null).getItems();
        }
        catch (ApiException apiException) {
            throw new RuntimeException(apiException.getResponseBody(), apiException);
        }
    }

    private static List<StrippedSourceContainer> strippedSecrets(List<V1Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), KubernetesClientConfigUtils.transform(secret.getData()))).collect(Collectors.toList());
    }

    private static List<StrippedSourceContainer> strippedConfigMaps(List<V1ConfigMap> configMaps) {
        return configMaps.stream().map(configMap -> new StrippedSourceContainer(configMap.getMetadata().getLabels(), configMap.getMetadata().getName(), configMap.getData())).collect(Collectors.toList());
    }

    private static Map<String, String> transform(Map<String, byte[]> in) {
        return in.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> new String((byte[])en.getValue())));
    }
}

