/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapPropertySourceLocator;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientSecretsPropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.ConditionalOnKubernetesEnabled;
import org.springframework.cloud.kubernetes.commons.KubernetesCommonsAutoConfiguration;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.commons.config.KubernetesBootstrapConfiguration;
import org.springframework.cloud.kubernetes.commons.config.SecretsConfigProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnKubernetesEnabled
@AutoConfigureAfter(value={KubernetesBootstrapConfiguration.class})
public class KubernetesClientBootstrapConfiguration {

    @Configuration(proxyBeanMethods=false)
    @Import(value={KubernetesCommonsAutoConfiguration.class, KubernetesClientAutoConfiguration.class})
    protected static class KubernetesPropertySourceConfiguration {
        protected KubernetesPropertySourceConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.config.enabled"}, matchIfMissing=true)
        public KubernetesClientConfigMapPropertySourceLocator configMapPropertySourceLocator(ConfigMapConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
            return new KubernetesClientConfigMapPropertySourceLocator(coreV1Api, properties, kubernetesNamespaceProvider);
        }

        @Bean
        @ConditionalOnProperty(name={"spring.cloud.kubernetes.secrets.enabled"}, matchIfMissing=true)
        public KubernetesClientSecretsPropertySourceLocator secretsPropertySourceLocator(SecretsConfigProperties properties, CoreV1Api coreV1Api, KubernetesNamespaceProvider kubernetesNamespaceProvider) {
            return new KubernetesClientSecretsPropertySourceLocator(coreV1Api, kubernetesNamespaceProvider, properties);
        }
    }
}

