/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client;

import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.kubernetes.commons.AbstractKubernetesInfoContributor;
import org.springframework.cloud.kubernetes.commons.PodUtils;
import org.springframework.util.CollectionUtils;

final class KubernetesClientInfoContributor
extends AbstractKubernetesInfoContributor {
    private final PodUtils<V1Pod> utils;

    KubernetesClientInfoContributor(PodUtils<V1Pod> utils) {
        this.utils = utils;
    }

    public Map<String, Object> getDetails() {
        V1Pod current = (V1Pod)this.utils.currentPod().get();
        if (current != null) {
            HashMap details = CollectionUtils.newHashMap((int)7);
            details.put("inside", true);
            V1ObjectMeta meta = current.getMetadata();
            details.put("namespace", meta.getNamespace());
            details.put("podName", meta.getName());
            V1PodSpec spec = current.getSpec();
            details.put("serviceAccount", spec.getServiceAccountName());
            details.put("nodeName", spec.getNodeName());
            V1PodStatus status = current.getStatus();
            details.put("podIp", status.getPodIP());
            details.put("hostIp", status.getHostIP());
            return details;
        }
        return Collections.singletonMap("inside", false);
    }
}

