/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.heroku;

import java.util.HashMap;
import java.util.logging.Logger;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.app.BasicApplicationInstanceInfo;
import org.springframework.cloud.util.EnvironmentAccessor;

public class ApplicationInstanceInfoCreator {
    private static Logger logger = Logger.getLogger(ApplicationInstanceInfoCreator.class.getName());
    private EnvironmentAccessor environment;

    public ApplicationInstanceInfoCreator(EnvironmentAccessor environmentAccessor) {
        this.environment = environmentAccessor;
    }

    public ApplicationInstanceInfo createApplicationInstanceInfo() {
        String appname = this.environment.getEnvValue("SPRING_CLOUD_APP_NAME");
        if (appname == null) {
            logger.warning("Environment variable SPRING_CLOUD_APP_NAME not set. App name set to <unknown>");
            appname = "<unknown>";
        }
        String dyno = this.environment.getEnvValue("DYNO");
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("port", this.environment.getEnvValue("PORT"));
        appProperties.put("host", this.environment.getHost());
        return new BasicApplicationInstanceInfo(dyno, appname, appProperties);
    }
}

