/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.storage;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;

public class GoogleStorageResource
implements WritableResource {
    private static final Log LOGGER = LogFactory.getLog(GoogleStorageResource.class);
    private final Storage storage;
    private final URI location;
    private final String bucketName;
    private final String blobName;
    private final boolean autoCreateFiles;

    public GoogleStorageResource(Storage storage, String location, boolean autoCreateFiles) {
        Assert.notNull((Object)storage, (String)"Storage object can not be null");
        Assert.isTrue((boolean)location.startsWith("gs://"), (String)"Location must start with gs://");
        this.storage = storage;
        this.autoCreateFiles = autoCreateFiles;
        try {
            URI locationUri = new URI(location);
            this.bucketName = locationUri.getAuthority();
            if (this.getBucketName() == null) {
                throw new IllegalArgumentException("No bucket specified in the location: " + location);
            }
            this.blobName = locationUri.getPath() != null && locationUri.getPath().length() > 1 ? locationUri.getPath().substring(1) : null;
            if (this.blobName == null && !location.endsWith("/")) {
                locationUri = new URI(location + "/");
            }
            this.location = locationUri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid location: " + location, e);
        }
    }

    public GoogleStorageResource(Storage storage, String location) {
        this(storage, location, true);
    }

    public boolean isAutoCreateFiles() {
        return this.autoCreateFiles;
    }

    public boolean exists() {
        try {
            return this.isBucket() ? this.getBucket() != null : this.getBlob() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isReadable() {
        return !this.isBucket();
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return this.location.toURL();
    }

    public URI getURI() throws IOException {
        return this.location;
    }

    public Blob getBlob() throws IOException {
        return this.storage.get(this.getBlobId());
    }

    public URL createSignedUrl(TimeUnit timeUnit, long timePeriods, Storage.SignUrlOption ... options) throws IOException {
        if (LOGGER.isWarnEnabled() && !this.exists()) {
            LOGGER.warn((Object)("Creating signed URL for non-existing GCS object " + this.location));
        }
        return this.storage.signUrl(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), timePeriods, timeUnit, options);
    }

    public Blob createBlob() throws StorageException {
        return this.storage.create(BlobInfo.newBuilder((BlobId)this.getBlobId()).build(), new Storage.BlobTargetOption[0]);
    }

    public Bucket createBucket() {
        return this.storage.create(BucketInfo.newBuilder((String)this.bucketName).build(), new Storage.BucketTargetOption[0]);
    }

    public Bucket getBucket() {
        return this.storage.get(this.bucketName, new Storage.BucketGetOption[0]);
    }

    public boolean bucketExists() {
        return this.getBucket() != null;
    }

    private Blob throwExceptionForNullBlob(Blob blob) throws IOException {
        if (blob == null) {
            throw new FileNotFoundException("The blob was not found: " + this.location);
        }
        return blob;
    }

    public File getFile() throws IOException {
        throw new UnsupportedOperationException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    public long contentLength() throws IOException {
        return this.throwExceptionForNullBlob(this.getBlob()).getSize();
    }

    public long lastModified() throws IOException {
        return this.throwExceptionForNullBlob(this.getBlob()).getUpdateTime();
    }

    public GoogleStorageResource createRelative(String relativePath) throws IOException {
        return new GoogleStorageResource(this.storage, this.location.resolve(relativePath).toString(), this.autoCreateFiles);
    }

    public String getFilename() {
        return this.isBucket() ? this.bucketName : this.blobName;
    }

    public String getDescription() {
        return this.location.toString();
    }

    public InputStream getInputStream() throws IOException {
        if (this.isBucket()) {
            throw new IllegalStateException("Cannot open an input stream to a bucket: '" + this.location + "'");
        }
        return Channels.newInputStream((ReadableByteChannel)this.throwExceptionForNullBlob(this.getBlob()).reader(new Blob.BlobSourceOption[0]));
    }

    public boolean isWritable() {
        return !this.isBucket() && (this.autoCreateFiles || this.exists());
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.isBucket()) {
            throw new IllegalStateException("Cannot open an output stream to a bucket: '" + this.location + "'");
        }
        Blob blob = this.getBlob();
        if (blob == null || !blob.exists(new Blob.BlobSourceOption[0])) {
            if (!this.autoCreateFiles) {
                throw new FileNotFoundException("The blob was not found: " + this.location);
            }
            blob = this.createBlob();
        }
        return Channels.newOutputStream((WritableByteChannel)blob.writer(new Storage.BlobWriteOption[0]));
    }

    public String getBlobName() {
        return this.blobName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public boolean isBucket() {
        return this.blobName == null;
    }

    private BlobId getBlobId() {
        if (this.isBucket()) {
            throw new IllegalStateException("No blob id specified in the location: '" + this.location + "', and the operation is not allowed on buckets.");
        }
        return BlobId.of((String)this.bucketName, (String)this.blobName);
    }
}

