/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.storage;

import com.google.cloud.storage.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.gcp.storage.GoogleStorageProtocolResolverSettings;
import org.springframework.cloud.gcp.storage.GoogleStorageResource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class GoogleStorageProtocolResolver
implements ProtocolResolver,
BeanFactoryPostProcessor,
ResourceLoaderAware {
    public static final String PROTOCOL = "gs://";
    private static final Log logger = LogFactory.getLog(GoogleStorageProtocolResolver.class);
    private ConfigurableListableBeanFactory beanFactory;
    private Storage storage;
    private GoogleStorageProtocolResolverSettings googleStorageProtocolResolverSettings;

    GoogleStorageProtocolResolver() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private Storage getStorage() {
        if (this.storage == null) {
            this.storage = (Storage)this.beanFactory.getBean(Storage.class);
        }
        return this.storage;
    }

    private GoogleStorageProtocolResolverSettings getGoogleStorageProtocolResolverSettings() {
        if (this.googleStorageProtocolResolverSettings == null) {
            this.googleStorageProtocolResolverSettings = (GoogleStorageProtocolResolverSettings)this.beanFactory.getBean(GoogleStorageProtocolResolverSettings.class);
        }
        return this.googleStorageProtocolResolverSettings;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (DefaultResourceLoader.class.isAssignableFrom(resourceLoader.getClass())) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            logger.warn((Object)"The provided delegate resource loader is not an implementation of DefaultResourceLoader. Custom Protocol using gs:// prefix will not be enabled.");
        }
    }

    private GoogleStorageProtocolResolverSettings getSettings() {
        try {
            return this.getGoogleStorageProtocolResolverSettings();
        }
        catch (NoSuchBeanDefinitionException e) {
            return GoogleStorageProtocolResolverSettings.DEFAULT_GOOGLE_STORAGE_PROTOCOL_RESOLVER_SETTINGS;
        }
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (!location.startsWith(PROTOCOL)) {
            return null;
        }
        return new GoogleStorageResource(this.getStorage(), location, this.getSettings().isAutoCreateFiles());
    }
}

