/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.support;

import com.google.pubsub.v1.ProjectSubscriptionName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class PubSubSubscriptionUtils {
    private PubSubSubscriptionUtils() {
    }

    public static ProjectSubscriptionName toProjectSubscriptionName(String subscription, @Nullable String projectId) {
        Assert.notNull((Object)subscription, (String)"The subscription can't be null.");
        ProjectSubscriptionName projectSubscriptionName = null;
        if (ProjectSubscriptionName.isParsableFrom((String)subscription)) {
            projectSubscriptionName = ProjectSubscriptionName.parse((String)subscription);
        } else {
            Assert.notNull((Object)projectId, (String)"The project ID can't be null when using canonical subscription name.");
            projectSubscriptionName = ProjectSubscriptionName.of((String)projectId, (String)subscription);
        }
        return projectSubscriptionName;
    }
}

