/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.core.subscriber;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberOperations;
import org.springframework.cloud.gcp.pubsub.support.AcknowledgeablePubsubMessage;
import org.springframework.cloud.gcp.pubsub.support.BasicAcknowledgeablePubsubMessage;
import org.springframework.cloud.gcp.pubsub.support.SubscriberFactory;
import org.springframework.cloud.gcp.pubsub.support.converter.ConvertedAcknowledgeablePubsubMessage;
import org.springframework.cloud.gcp.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import org.springframework.cloud.gcp.pubsub.support.converter.PubSubMessageConverter;
import org.springframework.cloud.gcp.pubsub.support.converter.SimplePubSubMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class PubSubSubscriberTemplate
implements PubSubSubscriberOperations,
DisposableBean {
    private final SubscriberFactory subscriberFactory;
    private final SubscriberStub subscriberStub;
    private PubSubMessageConverter pubSubMessageConverter = new SimplePubSubMessageConverter();
    private final ExecutorService defaultAckExecutor = Executors.newSingleThreadExecutor();
    private Executor ackExecutor = this.defaultAckExecutor;

    public PubSubSubscriberTemplate(SubscriberFactory subscriberFactory) {
        Assert.notNull((Object)subscriberFactory, (String)"The subscriberFactory can't be null.");
        this.subscriberFactory = subscriberFactory;
        this.subscriberStub = this.subscriberFactory.createSubscriberStub();
    }

    public PubSubMessageConverter getMessageConverter() {
        return this.pubSubMessageConverter;
    }

    public void setMessageConverter(PubSubMessageConverter pubSubMessageConverter) {
        Assert.notNull((Object)pubSubMessageConverter, (String)"The pubSubMessageConverter can't be null.");
        this.pubSubMessageConverter = pubSubMessageConverter;
    }

    public void setAckExecutor(Executor ackExecutor) {
        Assert.notNull((Object)ackExecutor, (String)"ackExecutor can't be null.");
        this.ackExecutor = ackExecutor;
    }

    @Override
    @Deprecated
    public Subscriber subscribe(String subscription, MessageReceiver messageReceiver) {
        Assert.hasText((String)subscription, (String)"The subscription can't be null or empty.");
        Assert.notNull((Object)messageReceiver, (String)"The messageReceiver can't be null.");
        Subscriber subscriber = this.subscriberFactory.createSubscriber(subscription, messageReceiver);
        subscriber.startAsync();
        return subscriber;
    }

    @Override
    public Subscriber subscribe(String subscription, Consumer<BasicAcknowledgeablePubsubMessage> messageConsumer) {
        Assert.notNull(messageConsumer, (String)"The messageConsumer can't be null.");
        Subscriber subscriber = this.subscriberFactory.createSubscriber(subscription, (message, ackReplyConsumer) -> messageConsumer.accept(new PushedAcknowledgeablePubsubMessage(ProjectSubscriptionName.of((String)this.subscriberFactory.getProjectId(), (String)subscription), message, ackReplyConsumer)));
        subscriber.startAsync();
        return subscriber;
    }

    @Override
    public <T> Subscriber subscribeAndConvert(String subscription, Consumer<ConvertedBasicAcknowledgeablePubsubMessage<T>> messageConsumer, Class<T> payloadType) {
        Assert.notNull(messageConsumer, (String)"The messageConsumer can't be null.");
        Subscriber subscriber = this.subscriberFactory.createSubscriber(subscription, (message, ackReplyConsumer) -> messageConsumer.accept(new ConvertedPushedAcknowledgeablePubsubMessage(ProjectSubscriptionName.of((String)this.subscriberFactory.getProjectId(), (String)subscription), message, this.getMessageConverter().fromPubSubMessage(message, payloadType), ackReplyConsumer)));
        subscriber.startAsync();
        return subscriber;
    }

    private List<AcknowledgeablePubsubMessage> pull(PullRequest pullRequest) {
        Assert.notNull((Object)pullRequest, (String)"The pull request can't be null.");
        PullResponse pullResponse = (PullResponse)this.subscriberStub.pullCallable().call((Object)pullRequest);
        return pullResponse.getReceivedMessagesList().stream().map(message -> new PulledAcknowledgeablePubsubMessage(ProjectSubscriptionName.of((String)this.subscriberFactory.getProjectId(), (String)pullRequest.getSubscription()), message.getMessage(), message.getAckId())).collect(Collectors.toList());
    }

    @Override
    public List<AcknowledgeablePubsubMessage> pull(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pull(this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately));
    }

    @Override
    public <T> List<ConvertedAcknowledgeablePubsubMessage<T>> pullAndConvert(String subscription, Integer maxMessages, Boolean returnImmediately, Class<T> payloadType) {
        List<AcknowledgeablePubsubMessage> ackableMessages = this.pull(subscription, maxMessages, returnImmediately);
        return ackableMessages.stream().map(m -> new ConvertedPulledAcknowledgeablePubsubMessage((AcknowledgeablePubsubMessage)m, this.pubSubMessageConverter.fromPubSubMessage(m.getPubsubMessage(), payloadType))).collect(Collectors.toList());
    }

    @Override
    public List<PubsubMessage> pullAndAck(String subscription, Integer maxMessages, Boolean returnImmediately) {
        PullRequest pullRequest;
        List<AcknowledgeablePubsubMessage> ackableMessages;
        Assert.hasText((String)subscription, (String)"The subscription can't be null or empty.");
        if (maxMessages != null) {
            Assert.isTrue((maxMessages > 0 ? 1 : 0) != 0, (String)"The maxMessages must be greater than 0.");
        }
        if ((ackableMessages = this.pull(pullRequest = this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately))).size() > 0) {
            this.ack(ackableMessages);
        }
        return ackableMessages.stream().map(BasicAcknowledgeablePubsubMessage::getPubsubMessage).collect(Collectors.toList());
    }

    @Override
    public PubsubMessage pullNext(String subscription) {
        List<PubsubMessage> receivedMessageList = this.pullAndAck(subscription, 1, true);
        return receivedMessageList.size() > 0 ? receivedMessageList.get(0) : null;
    }

    public SubscriberFactory getSubscriberFactory() {
        return this.subscriberFactory;
    }

    @Override
    public ListenableFuture<Void> ack(Collection<AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        Assert.notEmpty(acknowledgeablePubsubMessages, (String)"The acknowledgeablePubsubMessages can't be empty.");
        return this.doBatchedAsyncOperation(acknowledgeablePubsubMessages, this::ack);
    }

    @Override
    public ListenableFuture<Void> nack(Collection<AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        return this.modifyAckDeadline(acknowledgeablePubsubMessages, 0);
    }

    @Override
    public ListenableFuture<Void> modifyAckDeadline(Collection<AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages, int ackDeadlineSeconds) {
        Assert.notEmpty(acknowledgeablePubsubMessages, (String)"The acknowledgeablePubsubMessages can't be empty.");
        Assert.isTrue((ackDeadlineSeconds >= 0 ? 1 : 0) != 0, (String)"The ackDeadlineSeconds must not be negative.");
        return this.doBatchedAsyncOperation(acknowledgeablePubsubMessages, (subscriptionName, ackIds) -> this.modifyAckDeadline((String)subscriptionName, (Collection<String>)ackIds, ackDeadlineSeconds));
    }

    public void destroy() {
        this.defaultAckExecutor.shutdown();
    }

    private ApiFuture<Empty> ack(String subscriptionName, Collection<String> ackIds) {
        AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().addAllAckIds(ackIds).setSubscription(subscriptionName).build();
        return this.subscriberStub.acknowledgeCallable().futureCall((Object)acknowledgeRequest);
    }

    private ApiFuture<Empty> modifyAckDeadline(String subscriptionName, Collection<String> ackIds, int ackDeadlineSeconds) {
        ModifyAckDeadlineRequest modifyAckDeadlineRequest = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(ackDeadlineSeconds).addAllAckIds(ackIds).setSubscription(subscriptionName).build();
        return this.subscriberStub.modifyAckDeadlineCallable().futureCall((Object)modifyAckDeadlineRequest);
    }

    private ListenableFuture<Void> doBatchedAsyncOperation(Collection<AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages, BiFunction<String, List<String>, ApiFuture<Empty>> asyncOperation) {
        Map groupedMessages = acknowledgeablePubsubMessages.stream().collect(Collectors.groupingBy(BasicAcknowledgeablePubsubMessage::getProjectSubscriptionName, Collectors.mapping(AcknowledgeablePubsubMessage::getAckId, Collectors.toList())));
        Assert.state((groupedMessages.keySet().stream().map(ProjectSubscriptionName::getProject).distinct().count() == 1L ? 1 : 0) != 0, (String)"The project id of all messages must match.");
        final SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
        final int numExpectedFutures = groupedMessages.size();
        final AtomicInteger numCompletedFutures = new AtomicInteger();
        groupedMessages.forEach((psName, ackIds) -> {
            ApiFuture ackApiFuture = (ApiFuture)asyncOperation.apply(psName.getSubscription(), (List<String>)ackIds);
            ApiFutures.addCallback((ApiFuture)ackApiFuture, (ApiFutureCallback)new ApiFutureCallback<Empty>(){

                public void onFailure(Throwable throwable) {
                    this.processResult(throwable);
                }

                public void onSuccess(Empty empty) {
                    this.processResult(null);
                }

                private void processResult(Throwable throwable) {
                    if (throwable != null) {
                        settableListenableFuture.setException(throwable);
                    } else if (numCompletedFutures.incrementAndGet() == numExpectedFutures) {
                        settableListenableFuture.set(null);
                    }
                }
            }, (Executor)this.ackExecutor);
        });
        return settableListenableFuture;
    }

    private static class ConvertedPushedAcknowledgeablePubsubMessage<T>
    extends PushedAcknowledgeablePubsubMessage
    implements ConvertedBasicAcknowledgeablePubsubMessage<T> {
        private final T payload;

        ConvertedPushedAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, T payload, AckReplyConsumer ackReplyConsumer) {
            super(projectSubscriptionName, message, ackReplyConsumer);
            this.payload = payload;
        }

        @Override
        public T getPayload() {
            return this.payload;
        }
    }

    private class ConvertedPulledAcknowledgeablePubsubMessage<T>
    extends PulledAcknowledgeablePubsubMessage
    implements ConvertedAcknowledgeablePubsubMessage<T> {
        private final T payload;

        ConvertedPulledAcknowledgeablePubsubMessage(AcknowledgeablePubsubMessage message, T payload) {
            super(message.getProjectSubscriptionName(), message.getPubsubMessage(), message.getAckId());
            this.payload = payload;
        }

        @Override
        public T getPayload() {
            return this.payload;
        }
    }

    private static class PushedAcknowledgeablePubsubMessage
    extends AbstractBasicAcknowledgeablePubsubMessage {
        private final AckReplyConsumer ackReplyConsumer;

        PushedAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
            super(projectSubscriptionName, message);
            this.ackReplyConsumer = ackReplyConsumer;
        }

        @Override
        public ListenableFuture<Void> ack() {
            SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
            try {
                this.ackReplyConsumer.ack();
                settableListenableFuture.set(null);
            }
            catch (Throwable throwable) {
                settableListenableFuture.setException(throwable);
            }
            return settableListenableFuture;
        }

        @Override
        public ListenableFuture<Void> nack() {
            SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
            try {
                this.ackReplyConsumer.nack();
                settableListenableFuture.set(null);
            }
            catch (Throwable throwable) {
                settableListenableFuture.setException(throwable);
            }
            return settableListenableFuture;
        }

        public String toString() {
            return "PushedAcknowledgeablePubsubMessage{projectId='" + this.getProjectSubscriptionName().getProject() + '\'' + ", subscriptionName='" + this.getProjectSubscriptionName().getSubscription() + '\'' + ", message=" + this.getPubsubMessage() + '}';
        }
    }

    private class PulledAcknowledgeablePubsubMessage
    extends AbstractBasicAcknowledgeablePubsubMessage
    implements AcknowledgeablePubsubMessage {
        private final String ackId;

        PulledAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, String ackId) {
            super(projectSubscriptionName, message);
            this.ackId = ackId;
        }

        @Override
        public String getAckId() {
            return this.ackId;
        }

        @Override
        public ListenableFuture<Void> ack() {
            return PubSubSubscriberTemplate.this.ack(Collections.singleton(this));
        }

        @Override
        public ListenableFuture<Void> nack() {
            return this.modifyAckDeadline(0);
        }

        @Override
        public ListenableFuture<Void> modifyAckDeadline(int ackDeadlineSeconds) {
            return PubSubSubscriberTemplate.this.modifyAckDeadline(Collections.singleton(this), ackDeadlineSeconds);
        }

        public String toString() {
            return "PulledAcknowledgeablePubsubMessage{projectId='" + this.getProjectSubscriptionName().getProject() + '\'' + ", subscriptionName='" + this.getProjectSubscriptionName().getSubscription() + '\'' + ", message=" + this.getPubsubMessage() + ", ackId='" + this.ackId + '\'' + '}';
        }
    }

    private static abstract class AbstractBasicAcknowledgeablePubsubMessage
    implements BasicAcknowledgeablePubsubMessage {
        private final ProjectSubscriptionName projectSubscriptionName;
        private final PubsubMessage message;

        AbstractBasicAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message) {
            this.projectSubscriptionName = projectSubscriptionName;
            this.message = message;
        }

        @Override
        public ProjectSubscriptionName getProjectSubscriptionName() {
            return this.projectSubscriptionName;
        }

        @Override
        public PubsubMessage getPubsubMessage() {
            return this.message;
        }
    }
}

