/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.integration.inbound;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.Subscriber;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.pubsub.core.PubSubException;
import org.springframework.cloud.gcp.pubsub.core.subscriber.PubSubSubscriberOperations;
import org.springframework.cloud.gcp.pubsub.integration.AckMode;
import org.springframework.cloud.gcp.pubsub.integration.PubSubHeaderMapper;
import org.springframework.cloud.gcp.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.util.Assert;

public class PubSubInboundChannelAdapter
extends MessageProducerSupport {
    private static final Log LOGGER = LogFactory.getLog(PubSubInboundChannelAdapter.class);
    private final String subscriptionName;
    private final PubSubSubscriberOperations pubSubSubscriberOperations;
    private Subscriber subscriber;
    private AckMode ackMode = AckMode.AUTO;
    private HeaderMapper<Map<String, String>> headerMapper = new PubSubHeaderMapper();
    private Class payloadType = byte[].class;

    public PubSubInboundChannelAdapter(PubSubSubscriberOperations pubSubSubscriberOperations, String subscriptionName) {
        Assert.notNull((Object)pubSubSubscriberOperations, (String)"Pub/Sub subscriber template can't be null.");
        Assert.notNull((Object)subscriptionName, (String)"Pub/Sub subscription name can't be null.");
        this.pubSubSubscriberOperations = pubSubSubscriberOperations;
        this.subscriptionName = subscriptionName;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"The acknowledgement mode can't be null.");
        this.ackMode = ackMode;
    }

    public Class getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(Class payloadType) {
        Assert.notNull((Object)payloadType, (String)"The payload type cannot be null.");
        this.payloadType = payloadType;
    }

    public void setHeaderMapper(HeaderMapper<Map<String, String>> headerMapper) {
        Assert.notNull(headerMapper, (String)"The header mapper can't be null.");
        this.headerMapper = headerMapper;
    }

    protected void doStart() {
        super.doStart();
        this.subscriber = this.pubSubSubscriberOperations.subscribeAndConvert(this.subscriptionName, this::consumeMessage, this.payloadType);
    }

    protected void doStop() {
        if (this.subscriber != null) {
            this.subscriber.stopAsync();
        }
        super.doStop();
    }

    private void consumeMessage(final ConvertedBasicAcknowledgeablePubsubMessage message) {
        Map messageHeaders = this.headerMapper.toHeaders((Object)message.getPubsubMessage().getAttributesMap());
        if (this.ackMode == AckMode.MANUAL) {
            messageHeaders.put("gcp_pubsub_original_message", message);
            messageHeaders.put("gcp_pubsub_acknowledgement", new AckReplyConsumer(){

                public void ack() {
                    LOGGER.warn((Object)"ACKNOWLEDGEMENT header is deprecated. Please use ORIGINAL_MESSAGE header to ack.");
                    message.ack();
                }

                public void nack() {
                    LOGGER.warn((Object)"ACKNOWLEDGEMENT header is deprecated. Please use ORIGINAL_MESSAGE header to nack.");
                    message.nack();
                }
            });
        }
        try {
            this.sendMessage(this.getMessageBuilderFactory().withPayload(message.getPayload()).copyHeaders(messageHeaders).build());
        }
        catch (RuntimeException re) {
            if (this.ackMode == AckMode.AUTO) {
                message.nack();
            }
            throw new PubSubException("Sending Spring message failed.", re);
        }
        if (this.ackMode == AckMode.AUTO || this.ackMode == AckMode.AUTO_ACK) {
            message.ack();
        }
    }
}

