/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.Map;
import org.springframework.cloud.gcp.pubsub.support.converter.PubSubMessageConversionException;
import org.springframework.cloud.gcp.pubsub.support.converter.PubSubMessageConverter;
import org.springframework.util.Assert;

public class JacksonPubSubMessageConverter
implements PubSubMessageConverter {
    private final ObjectMapper objectMapper;

    public JacksonPubSubMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"A valid ObjectMapper is required.");
        this.objectMapper = objectMapper;
    }

    @Override
    public PubsubMessage toPubSubMessage(Object payload, Map<String, String> headers) {
        try {
            PubsubMessage.Builder pubsubMessageBuilder = PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])this.objectMapper.writeValueAsBytes(payload)));
            if (headers != null) {
                pubsubMessageBuilder.putAllAttributes(headers);
            }
            return pubsubMessageBuilder.build();
        }
        catch (JsonProcessingException ex) {
            throw new PubSubMessageConversionException("JSON serialization of an object of type " + payload.getClass().getName() + " failed.", ex);
        }
    }

    @Override
    public <T> T fromPubSubMessage(PubsubMessage message, Class<T> payloadType) {
        try {
            return (T)this.objectMapper.readerFor(payloadType).readValue(message.getData().toByteArray());
        }
        catch (IOException ex) {
            throw new PubSubMessageConversionException("JSON deserialization of an object of type " + payloadType.getName() + " failed.", ex);
        }
    }
}

