/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub.core.publisher;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.pubsub.v1.PubsubMessage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.pubsub.core.publisher.PubSubPublisherOperations;
import org.springframework.cloud.gcp.pubsub.support.PublisherFactory;
import org.springframework.cloud.gcp.pubsub.support.converter.PubSubMessageConverter;
import org.springframework.cloud.gcp.pubsub.support.converter.SimplePubSubMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class PubSubPublisherTemplate
implements PubSubPublisherOperations {
    private static final Log LOGGER = LogFactory.getLog(PubSubPublisherTemplate.class);
    private PubSubMessageConverter pubSubMessageConverter = new SimplePubSubMessageConverter();
    private final PublisherFactory publisherFactory;

    public PubSubPublisherTemplate(PublisherFactory publisherFactory) {
        Assert.notNull((Object)publisherFactory, (String)"The publisherFactory can't be null.");
        this.publisherFactory = publisherFactory;
    }

    public PubSubMessageConverter getMessageConverter() {
        return this.pubSubMessageConverter;
    }

    public void setMessageConverter(PubSubMessageConverter pubSubMessageConverter) {
        Assert.notNull((Object)pubSubMessageConverter, (String)"The pubSubMessageConverter can't be null.");
        this.pubSubMessageConverter = pubSubMessageConverter;
    }

    @Override
    public <T> ListenableFuture<String> publish(String topic, T payload, Map<String, String> headers) {
        return this.publish(topic, this.pubSubMessageConverter.toPubSubMessage(payload, headers));
    }

    @Override
    public <T> ListenableFuture<String> publish(String topic, T payload) {
        return this.publish(topic, payload, null);
    }

    @Override
    public ListenableFuture<String> publish(final String topic, PubsubMessage pubsubMessage) {
        Assert.hasText((String)topic, (String)"The topic can't be null or empty.");
        Assert.notNull((Object)pubsubMessage, (String)"The pubsubMessage can't be null.");
        ApiFuture publishFuture = this.publisherFactory.createPublisher(topic).publish(pubsubMessage);
        final SettableListenableFuture settableFuture = new SettableListenableFuture();
        ApiFutures.addCallback((ApiFuture)publishFuture, (ApiFutureCallback)new ApiFutureCallback<String>(){

            public void onFailure(Throwable throwable) {
                LOGGER.warn((Object)("Publishing to " + topic + " topic failed."), throwable);
                settableFuture.setException(throwable);
            }

            public void onSuccess(String result) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Publishing to " + topic + " was successful. Message ID: " + result));
                }
                settableFuture.set((Object)result);
            }
        });
        return settableFuture;
    }

    public PublisherFactory getPublisherFactory() {
        return this.publisherFactory;
    }
}

