/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.common.collect.Lists;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import java.io.IOException;
import java.util.List;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.util.Assert;

public class PubSubAdmin {
    private static final int MIN_ACK_DEADLINE_SECONDS = 10;
    private static final int MAX_ACK_DEADLINE_SECONDS = 600;
    private final String projectId;
    private final TopicAdminClient topicAdminClient;
    private final SubscriptionAdminClient subscriptionAdminClient;
    private int defaultAckDeadline = 10;

    public PubSubAdmin(GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this(projectIdProvider, TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(credentialsProvider)).build()), SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(credentialsProvider)).build()));
    }

    public PubSubAdmin(GcpProjectIdProvider projectIdProvider, TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        Assert.notNull((Object)topicAdminClient, (String)"The topic administration client can't be null");
        Assert.notNull((Object)subscriptionAdminClient, (String)"The subscription administration client can't be null");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
        this.topicAdminClient = topicAdminClient;
        this.subscriptionAdminClient = subscriptionAdminClient;
    }

    public Topic createTopic(String topicName) {
        Assert.hasText((String)topicName, (String)"No topic name was specified.");
        return this.topicAdminClient.createTopic(ProjectTopicName.of((String)this.projectId, (String)topicName));
    }

    public Topic getTopic(String topicName) {
        Assert.hasText((String)topicName, (String)"No topic name was specified.");
        try {
            return this.topicAdminClient.getTopic(ProjectTopicName.of((String)this.projectId, (String)topicName));
        }
        catch (ApiException aex) {
            if (aex.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND) {
                return null;
            }
            throw aex;
        }
    }

    public void deleteTopic(String topicName) {
        Assert.hasText((String)topicName, (String)"No topic name was specified.");
        this.topicAdminClient.deleteTopic(ProjectTopicName.of((String)this.projectId, (String)topicName));
    }

    public List<Topic> listTopics() {
        TopicAdminClient.ListTopicsPagedResponse topicListPage = this.topicAdminClient.listTopics(ProjectName.of((String)this.projectId));
        return Lists.newArrayList((Iterable)topicListPage.iterateAll());
    }

    public Subscription createSubscription(String subscriptionName, String topicName) {
        return this.createSubscription(subscriptionName, topicName, null, null);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, Integer ackDeadline) {
        return this.createSubscription(subscriptionName, topicName, ackDeadline, null);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, String pushEndpoint) {
        return this.createSubscription(subscriptionName, topicName, null, pushEndpoint);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, Integer ackDeadline, String pushEndpoint) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified.");
        Assert.hasText((String)topicName, (String)"No topic name was specified.");
        int finalAckDeadline = this.defaultAckDeadline;
        if (ackDeadline != null) {
            Assert.isTrue((ackDeadline >= 10 && ackDeadline <= 600 ? 1 : 0) != 0, (String)"The acknowledgement deadline must be between 10 and 600 seconds.");
            finalAckDeadline = ackDeadline;
        }
        PushConfig.Builder pushConfigBuilder = PushConfig.newBuilder();
        if (pushEndpoint != null) {
            pushConfigBuilder.setPushEndpoint(pushEndpoint);
        }
        return this.subscriptionAdminClient.createSubscription(ProjectSubscriptionName.of((String)this.projectId, (String)subscriptionName), ProjectTopicName.of((String)this.projectId, (String)topicName), pushConfigBuilder.build(), finalAckDeadline);
    }

    public Subscription getSubscription(String subscriptionName) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified");
        try {
            return this.subscriptionAdminClient.getSubscription(ProjectSubscriptionName.of((String)this.projectId, (String)subscriptionName));
        }
        catch (ApiException aex) {
            if (aex.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND) {
                return null;
            }
            throw aex;
        }
    }

    public void deleteSubscription(String subscriptionName) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified");
        this.subscriptionAdminClient.deleteSubscription(ProjectSubscriptionName.of((String)this.projectId, (String)subscriptionName));
    }

    public List<Subscription> listSubscriptions() {
        SubscriptionAdminClient.ListSubscriptionsPagedResponse subscriptionsPage = this.subscriptionAdminClient.listSubscriptions(ProjectName.of((String)this.projectId));
        return Lists.newArrayList((Iterable)subscriptionsPage.iterateAll());
    }

    public int getDefaultAckDeadline() {
        return this.defaultAckDeadline;
    }

    public void setDefaultAckDeadline(int defaultAckDeadline) {
        Assert.isTrue((defaultAckDeadline >= 10 && defaultAckDeadline <= 600 ? 1 : 0) != 0, (String)"The acknowledgement deadline must be between 10 and 600 seconds.");
        this.defaultAckDeadline = defaultAckDeadline;
    }
}

