/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class SpannerReadOptions {
    private List<Options.ReadOption> readOptions = new ArrayList<Options.ReadOption>();
    private Timestamp timestamp;
    private String index;
    private Set<String> includeProperties;
    private boolean allowPartialRead;

    public SpannerReadOptions addReadOption(Options.ReadOption readOption) {
        Assert.notNull((Object)readOption, (String)"Valid read option is required!");
        this.readOptions.add(readOption);
        return this;
    }

    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    public SpannerReadOptions setIncludeProperties(Set<String> includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public SpannerReadOptions setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public SpannerReadOptions setIndex(String index) {
        this.index = index;
        return this;
    }

    public Options.ReadOption[] getReadOptions() {
        return this.readOptions.toArray(new Options.ReadOption[this.readOptions.size()]);
    }

    public boolean isAllowPartialRead() {
        return this.allowPartialRead;
    }

    public SpannerReadOptions setAllowPartialRead(boolean allowPartialRead) {
        this.allowPartialRead = allowPartialRead;
        return this;
    }
}

