/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.repository.query.Query;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SpannerQueryMethod
extends QueryMethod {
    private final Method method;
    private final MappingContext<? extends SpannerPersistentEntity<?>, SpannerPersistentProperty> mappingContext;

    public SpannerQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends SpannerPersistentEntity<?>, SpannerPersistentProperty> mappingContext) {
        super(method, metadata, factory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.method = method;
        this.mappingContext = mappingContext;
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    private Optional<String> findAnnotatedQuery() {
        return Optional.ofNullable(this.getQueryAnnotation()).map(AnnotationUtils::getValue).map(it -> (String)it).filter(StringUtils::hasText);
    }

    @Nullable
    Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }
}

