/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.spanner.Struct;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerCustomConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityReader;
import org.springframework.cloud.gcp.data.spanner.core.convert.StructAccessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.mapping.model.PropertyValueProvider;

class StructPropertyValueProvider
implements PropertyValueProvider<SpannerPersistentProperty> {
    private final SpannerCustomConverter readConverter;
    private SpannerEntityReader entityReader;
    private StructAccessor structAccessor;
    private boolean allowMissingColumns;

    StructPropertyValueProvider(StructAccessor structAccessor, SpannerCustomConverter readConverter, SpannerEntityReader entityReader) {
        this(structAccessor, readConverter, entityReader, false);
    }

    StructPropertyValueProvider(StructAccessor structAccessor, SpannerCustomConverter readConverter, SpannerEntityReader entityReader, boolean allowMissingColumns) {
        this.structAccessor = structAccessor;
        this.readConverter = readConverter;
        this.entityReader = entityReader;
        this.allowMissingColumns = allowMissingColumns;
    }

    public <T> T getPropertyValue(SpannerPersistentProperty spannerPersistentProperty) {
        Iterable<T> value;
        String colName = spannerPersistentProperty.getColumnName();
        if (!this.structAccessor.hasColumn(colName)) {
            throw new SpannerDataException("Column not found: " + colName);
        }
        Class propType = spannerPersistentProperty.getType();
        Iterable<T> iterable = value = ConversionUtils.isIterableNonByteArrayType(propType) ? this.readIterableWithConversion(spannerPersistentProperty) : this.readSingleWithConversion(spannerPersistentProperty);
        if (value == null) {
            throw new SpannerDataException(String.format("The value in column with name %s could not be converted to the corresponding property in the entity. The property's type is %s.", colName, propType));
        }
        return (T)value;
    }

    private <T> T readSingleWithConversion(SpannerPersistentProperty spannerPersistentProperty) {
        String colName = spannerPersistentProperty.getColumnName();
        Object value = this.structAccessor.getSingleValue(colName);
        return value != null ? (T)this.convertOrRead(spannerPersistentProperty.getType(), value) : null;
    }

    private <T> T convertOrRead(Class<T> targetType, Object sourceValue) {
        Class<?> sourceClass = sourceValue.getClass();
        return Struct.class.isAssignableFrom(sourceClass) && !this.readConverter.canConvert(sourceClass, targetType) ? this.entityReader.read(targetType, (Struct)sourceValue, null, this.allowMissingColumns) : this.readConverter.convert(sourceValue, targetType);
    }

    private <T> Iterable<T> readIterableWithConversion(SpannerPersistentProperty spannerPersistentProperty) {
        String colName = spannerPersistentProperty.getColumnName();
        List listValue = this.structAccessor.getListValue(colName);
        return this.convertOrReadIterable(listValue, spannerPersistentProperty.getColumnInnerType());
    }

    private <T> Iterable<T> convertOrReadIterable(Iterable<?> source, Class<T> targetType) {
        ArrayList result = new ArrayList();
        source.forEach(item -> result.add(this.convertOrRead(targetType, item)));
        return result;
    }
}

