/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import javax.annotation.Nullable;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class SpannerTransactionManager
extends AbstractPlatformTransactionManager {
    private final DatabaseClient databaseClient;

    public SpannerTransactionManager(DatabaseClient databaseClient) {
        this.databaseClient = databaseClient;
    }

    protected Tx getCurrentTX() {
        try {
            return (Tx)((DefaultTransactionStatus)TransactionAspectSupport.currentTransactionStatus()).getTransaction();
        }
        catch (NoTransactionException ex) {
            return null;
        }
    }

    protected Object doGetTransaction() throws TransactionException {
        Tx tx = this.getCurrentTX();
        if (tx != null && tx.transactionManager.getState() == TransactionManager.TransactionState.STARTED) {
            this.logger.debug((Object)(tx + " reuse; state = " + tx.transactionManager.getState()));
            return tx;
        }
        tx = new Tx();
        tx.transactionManager = this.databaseClient.transactionManager();
        this.logger.debug((Object)(tx + " create; state = " + tx.transactionManager.getState()));
        return tx;
    }

    protected void doBegin(Object transactionObject, TransactionDefinition transactionDefinition) throws TransactionException {
        if (transactionDefinition.getIsolationLevel() != -1) {
            throw new IllegalStateException("SpannerTransactionManager supports only isolation level TransactionDefinition.ISOLATION_DEFAULT");
        }
        if (transactionDefinition.getPropagationBehavior() != 0) {
            throw new IllegalStateException("SpannerTransactionManager supports only propagation behavior TransactionDefinition.PROPAGATION_REQUIRED");
        }
        Tx tx = (Tx)transactionObject;
        if (transactionDefinition.isReadOnly()) {
            ReadOnlyTransaction targetTransactionContext = this.databaseClient.readOnlyTransaction();
            tx.transactionContext = new TransactionContext((ReadContext)targetTransactionContext){
                final /* synthetic */ ReadContext val$targetTransactionContext;
                {
                    this.val$targetTransactionContext = readContext;
                }

                public void buffer(Mutation mutation) {
                    throw new IllegalStateException("Spanner transaction cannot apply mutation because it is in readonly mode");
                }

                public void buffer(Iterable<Mutation> iterable) {
                    throw new IllegalStateException("Spanner transaction cannot apply mutations because it is in readonly mode");
                }

                public long executeUpdate(Statement statement) {
                    throw new IllegalStateException("Spanner transaction cannot execute DML because it is in readonly mode");
                }

                public ResultSet read(String s, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.read(s, keySet, iterable, readOptions);
                }

                public ResultSet readUsingIndex(String s, String s1, KeySet keySet, Iterable<String> iterable, Options.ReadOption ... readOptions) {
                    return this.val$targetTransactionContext.readUsingIndex(s, s1, keySet, iterable, readOptions);
                }

                @Nullable
                public Struct readRow(String s, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRow(s, key, iterable);
                }

                @Nullable
                public Struct readRowUsingIndex(String s, String s1, Key key, Iterable<String> iterable) {
                    return this.val$targetTransactionContext.readRowUsingIndex(s, s1, key, iterable);
                }

                public ResultSet executeQuery(Statement statement, Options.QueryOption ... queryOptions) {
                    return this.val$targetTransactionContext.executeQuery(statement, queryOptions);
                }

                public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryAnalyzeMode) {
                    return this.val$targetTransactionContext.analyzeQuery(statement, queryAnalyzeMode);
                }

                public void close() {
                    this.val$targetTransactionContext.close();
                }
            };
        } else {
            tx.transactionContext = tx.transactionManager.begin();
        }
        this.logger.debug((Object)(tx + " begin; state = " + tx.transactionManager.getState()));
    }

    protected void doCommit(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        try {
            this.logger.debug((Object)(tx + " beforeCommit; state = " + tx.transactionManager.getState()));
            if (tx.transactionManager.getState() == TransactionManager.TransactionState.STARTED) {
                tx.transactionManager.commit();
                this.logger.debug((Object)(tx + " afterCommit; state = " + tx.transactionManager.getState()));
            }
        }
        catch (AbortedException ex) {
            throw new UnexpectedRollbackException("Transaction Got Rolled Back", (Throwable)ex);
        }
        catch (SpannerException ex) {
            throw this.makeDataIntegrityViolationException(ex);
        }
    }

    private RuntimeException makeDataIntegrityViolationException(SpannerException e) {
        switch (e.getErrorCode()) {
            case ALREADY_EXISTS: {
                return new DuplicateKeyException(e.getErrorCode().toString(), (Throwable)e);
            }
        }
        return e;
    }

    protected void doRollback(DefaultTransactionStatus defaultTransactionStatus) throws TransactionException {
        Tx tx = (Tx)defaultTransactionStatus.getTransaction();
        this.logger.debug((Object)(tx + " beforeRollback; state = " + tx.transactionManager.getState()));
        if (tx.transactionManager.getState() == TransactionManager.TransactionState.STARTED) {
            tx.transactionManager.rollback();
        }
        this.logger.debug((Object)(tx + " afterRollback; state = " + tx.transactionManager.getState()));
    }

    protected boolean isExistingTransaction(Object transaction) {
        this.logger.debug((Object)("existing transaction " + transaction + "=" + this.getCurrentTX()));
        return transaction == this.getCurrentTX();
    }

    public static class Tx {
        private TransactionManager transactionManager;
        private TransactionContext transactionContext;

        public TransactionContext getTransactionContext() {
            return this.transactionContext;
        }
    }
}

