/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.data.spanner.core.ReadOnlyTransactionSpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.ReadWriteTransactionSpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.SpannerPageableQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerReadOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerTransactionManager;
import org.springframework.cloud.gcp.data.spanner.core.admin.SpannerSchemaUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerEntityProcessor;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerStatementQueryExecutor;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SpannerTemplate
implements SpannerOperations {
    private static final Log LOGGER = LogFactory.getLog(SpannerTemplate.class);
    private final DatabaseClient databaseClient;
    private final SpannerMappingContext mappingContext;
    private final SpannerEntityProcessor spannerEntityProcessor;
    private final SpannerMutationFactory mutationFactory;
    private final SpannerSchemaUtils spannerSchemaUtils;

    public SpannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerEntityProcessor spannerEntityProcessor, SpannerMutationFactory spannerMutationFactory, SpannerSchemaUtils spannerSchemaUtils) {
        Assert.notNull((Object)databaseClient, (String)"A valid database client for Spanner is required.");
        Assert.notNull((Object)((Object)mappingContext), (String)"A valid mapping context for Spanner is required.");
        Assert.notNull((Object)spannerEntityProcessor, (String)"A valid entity processor for Spanner is required.");
        Assert.notNull((Object)spannerMutationFactory, (String)"A valid Spanner mutation factory is required.");
        Assert.notNull((Object)spannerSchemaUtils, (String)"A valid Spanner schema utils is required.");
        this.databaseClient = databaseClient;
        this.mappingContext = mappingContext;
        this.spannerEntityProcessor = spannerEntityProcessor;
        this.mutationFactory = spannerMutationFactory;
        this.spannerSchemaUtils = spannerSchemaUtils;
    }

    protected ReadContext getReadContext() {
        return this.doWithOrWithoutTransactionContext(x -> x, () -> ((DatabaseClient)this.databaseClient).singleUse());
    }

    protected ReadContext getReadContext(Timestamp timestamp) {
        return this.doWithOrWithoutTransactionContext(x -> x, () -> this.databaseClient.singleUse(TimestampBound.ofReadTimestamp((Timestamp)timestamp)));
    }

    public SpannerMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public SpannerEntityProcessor getSpannerEntityProcessor() {
        return this.spannerEntityProcessor;
    }

    @Override
    public long executeDmlStatement(Statement statement) {
        return this.doWithOrWithoutTransactionContext(x -> x.executeUpdate(statement), () -> this.databaseClient.executePartitionedUpdate(statement));
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key) {
        return this.read(entityClass, key, null);
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key, SpannerReadOptions options) {
        List<T> items = this.read(entityClass, KeySet.singleKey((Key)key), options);
        return items.isEmpty() ? null : (T)items.get(0);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys) {
        return this.read(entityClass, keys, null);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys, SpannerReadOptions options) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.mapToListAndResolveChildren(this.executeRead(persistentEntity.tableName(), keys, persistentEntity.columns(), options), entityClass, options != null ? options.getIncludeProperties() : null, options != null && options.isAllowPartialRead());
    }

    @Override
    public <A> List<A> query(Function<Struct, A> rowFunc, Statement statement, SpannerQueryOptions options) {
        ArrayList<A> result = new ArrayList<A>();
        try (ResultSet resultSet = this.executeQuery(statement, options);){
            while (resultSet.next()) {
                result.add(rowFunc.apply(resultSet.getCurrentRowAsStruct()));
            }
        }
        return result;
    }

    @Override
    public <T> List<T> query(Class<T> entityClass, Statement statement, SpannerQueryOptions options) {
        return this.mapToListAndResolveChildren(this.executeQuery(statement, options), entityClass, options != null ? options.getIncludeProperties() : null, options != null && options.isAllowPartialRead());
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass, SpannerReadOptions options) {
        return this.read(entityClass, KeySet.all(), options);
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass) {
        return this.readAll(entityClass, null);
    }

    @Override
    public <T> List<T> queryAll(Class<T> entityClass, SpannerPageableQueryOptions options) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        String sql = "SELECT " + SpannerStatementQueryExecutor.getColumnsStringForSelect(persistentEntity) + " FROM " + persistentEntity.tableName();
        return this.query(entityClass, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(SpannerStatementQueryExecutor.applySortingPagingQueryOptions(entityClass, options, sql, this.mappingContext), null, null, null, null), (SpannerQueryOptions)options);
    }

    @Override
    public void insert(Object object) {
        this.applyMutations(this.mutationFactory.insert(object));
    }

    @Override
    public void insertAll(Iterable objects) {
        this.applyMutations(this.getMutationsForMultipleObjects(objects, this.mutationFactory::insert));
    }

    @Override
    public void update(Object object) {
        this.applyMutations(this.mutationFactory.update(object, null));
    }

    @Override
    public void updateAll(Iterable objects) {
        this.applyMutations(this.getMutationsForMultipleObjects(objects, x -> this.mutationFactory.update(x, null)));
    }

    @Override
    public void update(Object object, String ... includeProperties) {
        this.applyMutations(this.mutationFactory.update(object, (Set<String>)(includeProperties.length == 0 ? null : new HashSet<String>(Arrays.asList(includeProperties)))));
    }

    @Override
    public void update(Object object, Set<String> includeProperties) {
        this.applyMutations(this.mutationFactory.update(object, includeProperties));
    }

    @Override
    public void upsert(Object object) {
        this.applyMutations(this.mutationFactory.upsert(object, null));
    }

    @Override
    public void upsertAll(Iterable objects) {
        this.applyMutations(this.getMutationsForMultipleObjects(objects, x -> this.mutationFactory.upsert(x, null)));
    }

    @Override
    public void upsert(Object object, String ... includeProperties) {
        this.applyMutations(this.mutationFactory.upsert(object, (Set<String>)(includeProperties.length == 0 ? null : new HashSet<String>(Arrays.asList(includeProperties)))));
    }

    @Override
    public void upsert(Object object, Set<String> includeProperties) {
        this.applyMutations(this.mutationFactory.upsert(object, includeProperties));
    }

    @Override
    public void delete(Object entity) {
        this.applyMutations(Collections.singletonList(this.mutationFactory.delete(entity)));
    }

    @Override
    public void deleteAll(Iterable objects) {
        this.applyMutations(StreamSupport.stream(objects.spliterator(), false).map(this.mutationFactory::delete).collect(Collectors.toList()));
    }

    @Override
    public void delete(Class entityClass, Key key) {
        this.applyMutations(Collections.singletonList(this.mutationFactory.delete(entityClass, key)));
    }

    @Override
    public void delete(Class entityClass, KeySet keys) {
        this.applyMutations(Collections.singletonList(this.mutationFactory.delete(entityClass, keys)));
    }

    @Override
    public long count(Class entityClass) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Statement statement = Statement.of((String)String.format("SELECT COUNT(*) FROM %s", persistentEntity.tableName()));
        try (ResultSet resultSet = this.executeQuery(statement, null);){
            resultSet.next();
            long l = resultSet.getLong(0);
            return l;
        }
    }

    @Override
    public <T> T performReadWriteTransaction(final Function<SpannerTemplate, T> operations) {
        return (T)this.doWithOrWithoutTransactionContext(x -> {
            throw new IllegalStateException("There is already declarative transaction open. Spanner does not support nested transactions");
        }, () -> this.databaseClient.readWriteTransaction().run(new TransactionRunner.TransactionCallable<T>(){

            @Nullable
            public T run(TransactionContext transaction) {
                ReadWriteTransactionSpannerTemplate transactionSpannerTemplate = new ReadWriteTransactionSpannerTemplate(SpannerTemplate.this.databaseClient, SpannerTemplate.this.mappingContext, SpannerTemplate.this.spannerEntityProcessor, SpannerTemplate.this.mutationFactory, SpannerTemplate.this.spannerSchemaUtils, transaction);
                return operations.apply(transactionSpannerTemplate);
            }
        }));
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerTemplate, T> operations, SpannerReadOptions readOptions) {
        return (T)this.doWithOrWithoutTransactionContext(x -> {
            throw new IllegalStateException("There is already declarative transaction open. Spanner does not support nested transactions");
        }, () -> {
            SpannerReadOptions options = readOptions != null ? readOptions : new SpannerReadOptions();
            ReadOnlyTransaction readOnlyTransaction = options.getTimestamp() != null ? this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)options.getTimestamp())) : this.databaseClient.readOnlyTransaction();
            Throwable throwable = null;
            try {
                Object r = operations.apply(new ReadOnlyTransactionSpannerTemplate(this.databaseClient, this.mappingContext, this.spannerEntityProcessor, this.mutationFactory, this.spannerSchemaUtils, readOnlyTransaction));
                return r;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (readOnlyTransaction != null) {
                    SpannerTemplate.$closeResource(throwable, (AutoCloseable)readOnlyTransaction);
                }
            }
        });
    }

    public ResultSet executeQuery(Statement statement, SpannerQueryOptions options) {
        Stopwatch stopwatch = null;
        if (LOGGER.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
        }
        ResultSet resultSet = this.performQuery(statement, options);
        if (LOGGER.isDebugEnabled()) {
            String message = options == null ? "Executing query without additional options: " + statement : this.getQueryLogMessageWithOptions(statement, options);
            LOGGER.debug((Object)message);
            if (stopwatch != null) {
                stopwatch.stop();
                LOGGER.debug((Object)("Query elapsed milliseconds: " + stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            }
        }
        return resultSet;
    }

    private String getQueryLogMessageWithOptions(Statement statement, SpannerQueryOptions options) {
        StringBuilder logSb = new StringBuilder("Executing query").append(options.getTimestamp() != null ? " at timestamp" + options.getTimestamp() : "");
        for (Options.QueryOption queryOption : options.getQueryOptions()) {
            logSb.append(" with option: " + queryOption);
        }
        logSb.append(" : ").append(statement);
        String message = logSb.toString();
        return message;
    }

    private ResultSet performQuery(Statement statement, SpannerQueryOptions options) {
        ResultSet resultSet = options == null ? this.getReadContext().executeQuery(statement, new Options.QueryOption[0]) : (options.getTimestamp() != null ? this.getReadContext(options.getTimestamp()) : this.getReadContext()).executeQuery(statement, options.getQueryOptions());
        return resultSet;
    }

    private ResultSet executeRead(String tableName, KeySet keys, Iterable<String> columns, SpannerReadOptions options) {
        ReadContext readContext;
        Stopwatch stopwatch = null;
        if (LOGGER.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
        }
        ReadContext readContext2 = readContext = options != null && options.getTimestamp() != null ? this.getReadContext(options.getTimestamp()) : this.getReadContext();
        ResultSet resultSet = options == null ? this.getReadContext().read(tableName, keys, columns, new Options.ReadOption[0]) : (options.getIndex() != null ? readContext.readUsingIndex(tableName, options.getIndex(), keys, columns, options.getReadOptions()) : readContext.read(tableName, keys, columns, options.getReadOptions()));
        if (LOGGER.isDebugEnabled()) {
            StringBuilder logs = this.logColumns(tableName, keys, columns);
            this.logReadOptions(options, logs);
            LOGGER.debug((Object)logs.toString());
            if (stopwatch != null) {
                stopwatch.stop();
                LOGGER.debug((Object)("Read elapsed milliseconds: " + stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            }
        }
        return resultSet;
    }

    private void logReadOptions(SpannerReadOptions options, StringBuilder logs) {
        if (options == null) {
            return;
        }
        if (options.getTimestamp() != null) {
            logs.append(" at timestamp " + options.getTimestamp());
        }
        for (Options.ReadOption readOption : options.getReadOptions()) {
            logs.append(" with option: " + readOption);
        }
        if (options.getIndex() != null) {
            logs.append(" secondary index: " + options.getIndex());
        }
    }

    private StringBuilder logColumns(String tableName, KeySet keys, Iterable<String> columns) {
        StringBuilder logSb = new StringBuilder("Executing read on table " + tableName + " with keys: " + keys + " and columns: ");
        StringJoiner sj = new StringJoiner(",");
        columns.forEach(col -> sj.add((CharSequence)col));
        logSb.append(sj.toString());
        return logSb;
    }

    protected void applyMutations(Collection<Mutation> mutations) {
        LOGGER.debug((Object)("Applying Mutation: " + mutations));
        this.doWithOrWithoutTransactionContext(x -> {
            x.buffer((Iterable)mutations);
            return null;
        }, () -> {
            this.databaseClient.write((Iterable)mutations);
            return null;
        });
    }

    private <T> List<T> mapToListAndResolveChildren(ResultSet resultSet, Class<T> entityClass, Set<String> includeProperties, boolean allowMissingColumns) {
        return this.resolveChildEntities(this.spannerEntityProcessor.mapToList(resultSet, entityClass, includeProperties, allowMissingColumns), includeProperties);
    }

    private <T> List<T> resolveChildEntities(List<T> entities, Set<String> includeProperties) {
        for (T entity : entities) {
            this.resolveChildEntity(entity, includeProperties);
        }
        return entities;
    }

    private void resolveChildEntity(Object entity, Set<String> includeProperties) {
        SpannerPersistentEntity spannerPersistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        PersistentPropertyAccessor accessor = spannerPersistentEntity.getPropertyAccessor(entity);
        spannerPersistentEntity.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (includeProperties != null && !includeProperties.contains(spannerPersistentEntity.getName())) {
                return;
            }
            Class<?> childType = spannerPersistentProperty.getColumnInnerType();
            SpannerPersistentEntity childPersistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(childType);
            accessor.setProperty(spannerPersistentProperty, this.query(childType, SpannerStatementQueryExecutor.getChildrenRowsQuery(this.spannerSchemaUtils.getKey(entity), childPersistentEntity), null));
        }));
    }

    private Collection<Mutation> getMutationsForMultipleObjects(Iterable it, Function<Object, Collection<Mutation>> individualEntityMutationFunc) {
        return StreamSupport.stream(it.spliterator(), false).flatMap(x -> ((Collection)individualEntityMutationFunc.apply(x)).stream()).collect(Collectors.toList());
    }

    private TransactionContext getTransactionContext() {
        return TransactionSynchronizationManager.isActualTransactionActive() ? ((SpannerTransactionManager.Tx)((DefaultTransactionStatus)TransactionAspectSupport.currentTransactionStatus()).getTransaction()).getTransactionContext() : null;
    }

    private <A> A doWithOrWithoutTransactionContext(Function<TransactionContext, A> funcWithTransactionContext, Supplier<A> funcWithoutTransactionContext) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext != null ? funcWithTransactionContext.apply(txContext) : funcWithoutTransactionContext.get();
    }
}

