/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.support;

import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntityInformation;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerQueryLookupStrategy;
import org.springframework.cloud.gcp.data.spanner.repository.support.SimpleSpannerRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpannerRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationContextAware {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerOperations spannerOperations;
    private ApplicationContext applicationContext;

    public SpannerRepositoryFactory(SpannerMappingContext spannerMappingContext, SpannerOperations spannerOperations) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid Spanner mapping context is required.");
        Assert.notNull((Object)spannerOperations, (String)"A valid Spanner operations object is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.spannerOperations = spannerOperations;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        SpannerPersistentEntity entity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return new SpannerPersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.spannerOperations, metadata.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleSpannerRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new SpannerQueryLookupStrategy(this.spannerMappingContext, this.spannerOperations, this.delegateContextProvider(evaluationContextProvider), EXPRESSION_PARSER));
    }

    private EvaluationContextProvider delegateContextProvider(final EvaluationContextProvider evaluationContextProvider) {
        return new EvaluationContextProvider(){

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues);
                evaluationContext.setRootObject((Object)SpannerRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)SpannerRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }
        };
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

