/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.support;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.repository.SpannerRepository;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleSpannerRepository
implements SpannerRepository {
    private final SpannerOperations spannerOperations;
    private final Class entityType;

    public SimpleSpannerRepository(SpannerOperations spannerOperations, Class entityType) {
        Assert.notNull((Object)spannerOperations, (String)"A valid SpannerOperations object is required.");
        Assert.notNull((Object)entityType, (String)"A valid entity type is required.");
        this.spannerOperations = spannerOperations;
        this.entityType = entityType;
    }

    @Override
    public SpannerOperations getSpannerOperations() {
        return this.spannerOperations;
    }

    public Object save(Object entity) {
        Assert.notNull((Object)entity, (String)"A non-null entity is required for saving.");
        this.spannerOperations.upsert(entity);
        return entity;
    }

    public Iterable saveAll(Iterable entities) {
        Assert.notNull((Object)entities, (String)"A non-null list of entities is required for saving.");
        for (Object entity : entities) {
            this.save(entity);
        }
        return entities;
    }

    public Optional findById(Object key) {
        Assert.notNull((Object)key, (String)"A non-null ID is required.");
        return this.doIfKey(key, k -> Optional.ofNullable(this.spannerOperations.read(this.entityType, (Key)k)));
    }

    public boolean existsById(Object key) {
        Assert.notNull((Object)key, (String)"A non-null ID is required.");
        return this.findById(key).isPresent();
    }

    public Iterable findAll() {
        return this.spannerOperations.readAll(this.entityType);
    }

    public Iterable findAllById(Iterable iterable) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (Object id : iterable) {
            this.doIfKey(id, k -> builder.addKey(k));
        }
        return this.spannerOperations.read(this.entityType, builder.build());
    }

    public long count() {
        return this.spannerOperations.count(this.entityType);
    }

    public void deleteById(Object key) {
        Assert.notNull((Object)key, (String)"A non-null ID is required.");
        this.doIfKey(key, k -> {
            this.spannerOperations.delete(this.entityType, (Key)k);
            return null;
        });
    }

    public void delete(Object entity) {
        Assert.notNull((Object)entity, (String)"A non-null entity is required.");
        this.spannerOperations.delete(entity);
    }

    public void deleteAll(Iterable entities) {
        Assert.notNull((Object)entities, (String)"A non-null list of entities is required.");
        this.spannerOperations.delete(this.entityType, entities);
    }

    public void deleteAll() {
        this.spannerOperations.delete(this.entityType, KeySet.all());
    }

    public Iterable findAll(Sort sort) {
        return this.spannerOperations.queryAll(this.entityType, sort);
    }

    public Page findAll(Pageable pageable) {
        return this.spannerOperations.queryAll(this.entityType, pageable);
    }

    private <T> T doIfKey(Object key, Function<Key, T> operation) {
        Key k;
        boolean isIterable = Iterable.class.isAssignableFrom(key.getClass());
        boolean isArray = Object[].class.isAssignableFrom(key.getClass());
        if (isIterable || isArray) {
            Key.Builder kb = Key.newBuilder();
            for (Object t : isArray ? Arrays.asList((Object[])key) : (List<Object>)key) {
                kb.appendObject(t);
            }
            k = kb.build();
            if (k.size() == 0) {
                throw new SpannerDataException("A key must have at least one component, but 0 were given.");
            }
        } else {
            k = key instanceof Key ? (Key)key : Key.of((Object[])new Object[]{key});
        }
        return (T)operation.apply(k);
    }
}

