/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerStatementQueryExecutor;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SqlSpannerQuery
implements RepositoryQuery {
    private static String ENTITY_CLASS_NAME_BOOKEND = ":";
    private final QueryMethod queryMethod;
    private final Class entityType;
    private final SpannerOperations spannerOperations;
    private final String sql;
    private final List<String> tags;
    private final SpannerMappingContext spannerMappingContext;
    private EvaluationContextProvider evaluationContextProvider;
    private SpelExpressionParser expressionParser;

    public SqlSpannerQuery(Class type, QueryMethod queryMethod, SpannerOperations spannerOperations, String sql, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser expressionParser, SpannerMappingContext spannerMappingContext) {
        this.queryMethod = queryMethod;
        this.entityType = type;
        this.spannerOperations = spannerOperations;
        this.tags = this.getTags(sql);
        this.evaluationContextProvider = evaluationContextProvider;
        this.expressionParser = expressionParser;
        this.spannerMappingContext = spannerMappingContext;
        this.sql = sql;
    }

    private List<String> getTags(String sql) {
        Pattern pattern = Pattern.compile("@\\S+");
        Matcher matcher = pattern.matcher(sql);
        ArrayList<String> tags = new ArrayList<String>();
        while (matcher.find()) {
            tags.add(matcher.group().substring(1));
        }
        return tags;
    }

    private String resolveEntityClassNames(String sql) {
        StringJoiner joiner = new StringJoiner(" ");
        for (String part : sql.split("\\s+")) {
            if (part.length() > 2 && part.startsWith(ENTITY_CLASS_NAME_BOOKEND) && part.endsWith(ENTITY_CLASS_NAME_BOOKEND)) {
                String className = part.substring(1, part.length() - 1);
                try {
                    Class<?> entityClass = Class.forName(className);
                    SpannerPersistentEntity spannerPersistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(entityClass);
                    if (spannerPersistentEntity == null) {
                        throw new SpannerDataException("The class used in the SQL statement is not a Spanner persistent entity: " + className);
                    }
                    joiner.add(spannerPersistentEntity.tableName());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new SpannerDataException("The class name does not refer to an available entity type: " + className);
                }
            }
            joiner.add(part);
        }
        return joiner.toString();
    }

    public Object execute(Object[] parameters) {
        return this.spannerOperations.query(this.entityType, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(this.resolveEntityClassNames(this.sql), this.tags, parameters));
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

