/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ValueBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.convert.MappingSpannerWriteConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Pair;

public class SpannerStatementQueryExecutor {
    public static Object executeQuery(Class type, PartTree tree, Object[] params, SpannerOperations spannerOperations, SpannerMappingContext spannerMappingContext) {
        if (tree.isDelete()) {
            throw new UnsupportedOperationException("Delete queries are not supported in Spanner");
        }
        Pair<String, List<String>> sqlAndTags = SpannerStatementQueryExecutor.buildPartTreeSqlString(tree, spannerMappingContext, type);
        List results = spannerOperations.query(type, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs((String)sqlAndTags.getFirst(), (List)sqlAndTags.getSecond(), params));
        if (tree.isCountProjection()) {
            return results.size();
        }
        if (tree.isExistsProjection()) {
            return !results.isEmpty();
        }
        return results;
    }

    public static Statement buildStatementFromSqlWithArgs(String sql, List<String> tags, Object[] params) {
        if (tags.size() != params.length) {
            throw new IllegalArgumentException("The number of tags does match the number of params.");
        }
        Statement.Builder builder = Statement.newBuilder((String)sql);
        for (int i = 0; i < tags.size(); ++i) {
            Object param = params[i];
            BiFunction<ValueBinder, ?, ?> toMethod = MappingSpannerWriteConverter.singleItemType2ToMethodMap.get(param.getClass());
            if (toMethod == null) {
                throw new IllegalArgumentException("Param: " + param.toString() + " is not a supported type: " + param.getClass());
            }
            builder = (Statement.Builder)toMethod.apply(builder.bind(tags.get(i)), param);
        }
        return builder.build();
    }

    private static Pair<String, List<String>> buildPartTreeSqlString(PartTree tree, SpannerMappingContext spannerMappingContext, Class type) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)spannerMappingContext.getPersistentEntity(type);
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        SpannerStatementQueryExecutor.buildSelect(tree, stringBuilder);
        SpannerStatementQueryExecutor.buildFrom(persistentEntity, stringBuilder);
        SpannerStatementQueryExecutor.buildWhere(tree, persistentEntity, tags, stringBuilder);
        SpannerStatementQueryExecutor.buildOrderBy(persistentEntity, stringBuilder, tree.getSort());
        SpannerStatementQueryExecutor.buildLimit(tree, stringBuilder);
        stringBuilder.append(";");
        return Pair.of((Object)stringBuilder.toString(), tags);
    }

    private static StringBuilder buildSelect(PartTree tree, StringBuilder stringBuilder) {
        stringBuilder.append("SELECT ");
        if (tree.isDistinct()) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append("* ");
        return stringBuilder;
    }

    private static void buildFrom(SpannerPersistentEntity<?> persistentEntity, StringBuilder stringBuilder) {
        stringBuilder.append("FROM " + persistentEntity.tableName() + " ");
    }

    public static void buildOrderBy(SpannerPersistentEntity<?> persistentEntity, StringBuilder stringBuilder, Sort sort) {
        if (sort.isSorted()) {
            stringBuilder.append("ORDER BY ");
            StringJoiner orderStrings = new StringJoiner(" , ");
            sort.iterator().forEachRemaining(o -> orderStrings.add(SpannerStatementQueryExecutor.ordering(persistentEntity, o)));
            stringBuilder.append(orderStrings.toString());
        }
    }

    private static String ordering(SpannerPersistentEntity<?> persistentEntity, Sort.Order order) {
        return ((SpannerPersistentProperty)persistentEntity.getPersistentProperty(order.getProperty())).getColumnName() + " " + SpannerStatementQueryExecutor.toString(order);
    }

    private static String toString(Sort.Order order) {
        return order.isAscending() ? "ASC" : "DESC";
    }

    private static void buildWhere(PartTree tree, SpannerPersistentEntity<?> persistentEntity, List<String> tags, StringBuilder stringBuilder) {
        if (tree.hasPredicate()) {
            stringBuilder.append("WHERE ");
            StringJoiner orStrings = new StringJoiner(" OR ");
            tree.iterator().forEachRemaining(orPart -> {
                String orString = "( ";
                StringJoiner andStrings = new StringJoiner(" AND ");
                orPart.forEach(part -> {
                    String segment = part.getProperty().getSegment();
                    String tag = "tag" + tags.size();
                    tags.add(tag);
                    String andString = ((SpannerPersistentProperty)persistentEntity.getPersistentProperty(segment)).getColumnName();
                    switch (part.getType()) {
                        case LIKE: {
                            andString = andString + " LIKE %@" + tag;
                            break;
                        }
                        case SIMPLE_PROPERTY: {
                            andString = andString + "=@" + tag;
                            break;
                        }
                        case TRUE: {
                            andString = andString + "=TRUE";
                            break;
                        }
                        case FALSE: {
                            andString = andString + "=FALSE";
                            break;
                        }
                        case IS_NULL: {
                            andString = andString + "=NULL";
                            break;
                        }
                        case LESS_THAN: {
                            andString = andString + "<@" + tag;
                            break;
                        }
                        case IS_NOT_NULL: {
                            andString = andString + "<>NULL";
                            break;
                        }
                        case LESS_THAN_EQUAL: {
                            andString = andString + "<=@" + tag;
                            break;
                        }
                        case GREATER_THAN: {
                            andString = andString + ">@" + tag;
                            break;
                        }
                        case GREATER_THAN_EQUAL: {
                            andString = andString + ">=@" + tag;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("The statement type: " + part.getType() + " is not supported.");
                        }
                    }
                    andStrings.add(andString);
                });
                orString = orString + andStrings.toString();
                orString = orString + " )";
                orStrings.add(orString);
            });
            stringBuilder.append(orStrings.toString());
        }
    }

    private static void buildLimit(PartTree tree, StringBuilder stringBuilder) {
        if (tree.isLimiting()) {
            stringBuilder.append(" LIMIT " + tree.getMaxResults());
        }
    }
}

