/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import java.lang.reflect.Method;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.repository.query.PartTreeSpannerQuery;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerQueryMethod;
import org.springframework.cloud.gcp.data.spanner.repository.query.SqlSpannerQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpannerQueryLookupStrategy
implements QueryLookupStrategy {
    private final SpannerOperations spannerOperations;
    private final SpannerMappingContext spannerMappingContext;
    private EvaluationContextProvider evaluationContextProvider;
    private SpelExpressionParser expressionParser;

    public SpannerQueryLookupStrategy(SpannerMappingContext spannerMappingContext, SpannerOperations spannerOperations, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser expressionParser) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid SpannerMappingContext is required.");
        Assert.notNull((Object)spannerOperations, (String)"A valid SpannerOperations is required.");
        Assert.notNull((Object)evaluationContextProvider, (String)"A valid EvaluationContextProvider is required.");
        Assert.notNull((Object)expressionParser, (String)"A valid SpelExpressionParser is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.spannerOperations = spannerOperations;
        this.expressionParser = expressionParser;
    }

    protected Class getEntityType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    protected SpannerQueryMethod createQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        return new SpannerQueryMethod(method, metadata, factory, (MappingContext<? extends SpannerPersistentEntity<?>, SpannerPersistentProperty>)this.spannerMappingContext);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        SpannerQueryMethod queryMethod = this.createQueryMethod(method, metadata, factory);
        Class entityType = this.getEntityType(queryMethod);
        if (queryMethod.hasAnnotatedQuery()) {
            String sql = queryMethod.getQueryAnnotation().value();
            return this.createSqlSpannerQuery(entityType, queryMethod, sql);
        }
        if (namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            String sql = namedQueries.getQuery(queryMethod.getNamedQueryName());
            return this.createSqlSpannerQuery(entityType, queryMethod, sql);
        }
        return this.createPartTreeSpannerQuery(entityType, queryMethod);
    }

    protected SqlSpannerQuery createSqlSpannerQuery(Class entityType, QueryMethod queryMethod, String sql) {
        return new SqlSpannerQuery(entityType, queryMethod, this.spannerOperations, sql, this.evaluationContextProvider, this.expressionParser, this.spannerMappingContext);
    }

    protected PartTreeSpannerQuery createPartTreeSpannerQuery(Class entityType, QueryMethod queryMethod) {
        return new PartTreeSpannerQuery(entityType, queryMethod, this.spannerOperations, this.spannerMappingContext);
    }
}

