/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.repository.query;

import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerStatementQueryExecutor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeSpannerQuery
implements RepositoryQuery {
    private final QueryMethod queryMethod;
    private final SpannerOperations spannerOperations;
    private final SpannerMappingContext spannerMappingContext;
    private final PartTree tree;
    private final Class entityType;

    public PartTreeSpannerQuery(Class type, QueryMethod queryMethod, SpannerOperations spannerOperations, SpannerMappingContext spannerMappingContext) {
        this.queryMethod = queryMethod;
        this.entityType = type;
        this.tree = new PartTree(queryMethod.getName(), type);
        this.spannerOperations = spannerOperations;
        this.spannerMappingContext = spannerMappingContext;
    }

    public Object execute(Object[] parameters) {
        return SpannerStatementQueryExecutor.executeQuery(this.entityType, this.tree, parameters, this.spannerOperations, this.spannerMappingContext);
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

