/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.mapping;

import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.springframework.cloud.gcp.data.spanner.core.mapping.Column;
import org.springframework.cloud.gcp.data.spanner.core.mapping.ColumnInnerType;
import org.springframework.cloud.gcp.data.spanner.core.mapping.PrimaryKey;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.core.mapping.Table;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class SpannerPersistentPropertyImpl
extends AnnotationBasedPersistentProperty<SpannerPersistentProperty>
implements SpannerPersistentProperty {
    private FieldNamingStrategy fieldNamingStrategy;

    public SpannerPersistentPropertyImpl(Property property, PersistentEntity<?, SpannerPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return StreamUtils.createStreamFromIterator(super.getPersistentEntityTypes().iterator()).filter(typeInfo -> typeInfo.getType().isAnnotationPresent(Table.class)).collect(Collectors.toList());
    }

    protected Association<SpannerPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public String getColumnName() {
        if (StringUtils.hasText((String)this.getAnnotatedColumnName())) {
            return this.getAnnotatedColumnName();
        }
        String fieldName = this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
        if (!StringUtils.hasText((String)fieldName)) {
            throw new MappingException(String.format("Invalid (null or empty) field name returned for property %s by %s!", this, this.fieldNamingStrategy.getClass()));
        }
        return fieldName;
    }

    @Override
    public Class getColumnInnerType() {
        ColumnInnerType annotation = (ColumnInnerType)this.findAnnotation(ColumnInnerType.class);
        if (annotation == null) {
            return null;
        }
        return annotation.innerType();
    }

    @Override
    public OptionalInt getPrimaryKeyOrder() {
        PrimaryKey annotation = (PrimaryKey)this.findAnnotation(PrimaryKey.class);
        if (annotation == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(annotation.keyOrder());
    }

    public boolean isIdProperty() {
        return false;
    }

    private String getAnnotatedColumnName() {
        Column annotation = (Column)this.findAnnotation(Column.class);
        if (annotation != null && StringUtils.hasText((String)annotation.name())) {
            return annotation.name();
        }
        return null;
    }
}

