/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerCompositeKeyProperty;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.cloud.gcp.data.spanner.core.mapping.Table;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SpannerPersistentEntityImpl<T>
extends BasicPersistentEntity<T, SpannerPersistentProperty>
implements SpannerPersistentEntity<T> {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final String tableName;
    private final Set<String> columnNames = new HashSet<String>();
    private final Expression tableNameExpression;
    private StandardEvaluationContext context;
    private final Table table;
    private final Map<Integer, SpannerPersistentProperty> primaryKeyParts = new HashMap<Integer, SpannerPersistentProperty>();
    private SpannerPersistentProperty idProperty;

    public SpannerPersistentEntityImpl(TypeInformation<T> information) {
        super(information);
        Class rawType = information.getType();
        String fallback = StringUtils.uncapitalize((String)rawType.getSimpleName());
        this.context = new StandardEvaluationContext();
        this.table = (Table)this.findAnnotation(Table.class);
        this.tableName = this.hasTableName() ? this.table.name() : fallback;
        this.tableNameExpression = this.detectExpression();
    }

    protected boolean hasTableName() {
        return this.table != null && StringUtils.hasText((String)this.table.name());
    }

    @Nullable
    private Expression detectExpression() {
        if (!this.hasTableName()) {
            return null;
        }
        Expression expression = PARSER.parseExpression(this.table.name(), ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    public void addPersistentProperty(SpannerPersistentProperty property) {
        this.addPersistentPropertyToPersistentEntity(property);
        this.columnNames.add(property.getColumnName());
        if (property.getPrimaryKeyOrder() != null && property.getPrimaryKeyOrder().isPresent()) {
            int order = property.getPrimaryKeyOrder().getAsInt();
            if (this.primaryKeyParts.containsKey(order)) {
                throw new SpannerDataException("Two properties were annotated with the same primary key order: " + property.getColumnName() + " and " + this.primaryKeyParts.get(order).getColumnName());
            }
            this.primaryKeyParts.put(order, property);
        }
    }

    private void addPersistentPropertyToPersistentEntity(SpannerPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
    }

    public SpannerPersistentProperty getIdProperty() {
        return this.idProperty;
    }

    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    public void verify() {
        super.verify();
        for (int i = 1; i <= this.primaryKeyParts.size(); ++i) {
            SpannerPersistentProperty keyPart = this.primaryKeyParts.get(i);
            if (keyPart != null) continue;
            throw new SpannerDataException("The primary key columns were not given a consecutive order. There is no property annotated with order " + String.valueOf(i));
        }
        this.idProperty = new SpannerCompositeKeyProperty(this, this.getPrimaryKeyProperties());
    }

    private SpannerPersistentProperty[] getPrimaryKeyProperties() {
        if (this.primaryKeyParts.isEmpty()) {
            throw new SpannerDataException("At least one primary key property is required!");
        }
        SpannerPersistentProperty[] primaryKeyColumns = new SpannerPersistentProperty[this.primaryKeyParts.size()];
        for (int i = 1; i <= this.primaryKeyParts.size(); ++i) {
            primaryKeyColumns[i - 1] = this.primaryKeyParts.get(i);
        }
        return primaryKeyColumns;
    }

    @Override
    public String tableName() {
        return this.tableNameExpression == null ? this.tableName : (String)this.tableNameExpression.getValue((EvaluationContext)this.context, String.class);
    }

    @Override
    public Iterable<String> columns() {
        return Collections.unmodifiableSet(this.columnNames);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    public PersistentPropertyAccessor getPropertyAccessor(Object object) {
        final PersistentPropertyAccessor delegatedAccessor = super.getPropertyAccessor(object);
        return new PersistentPropertyAccessor(){

            public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
                if (property.isIdProperty()) {
                    throw new SpannerDataException("Setting the primary key directly via the Key ID property is not supported. Please set the underlying column properties.");
                }
                delegatedAccessor.setProperty(property, value);
            }

            @Nullable
            public Object getProperty(PersistentProperty<?> property) {
                if (property.isIdProperty()) {
                    return ((SpannerCompositeKeyProperty)property).getId(this.getBean());
                }
                return delegatedAccessor.getProperty(property);
            }

            public Object getBean() {
                return delegatedAccessor.getBean();
            }
        };
    }
}

