/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.mapping;

import com.google.cloud.spanner.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.OptionalInt;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpannerCompositeKeyProperty
implements SpannerPersistentProperty {
    private final SpannerPersistentEntity spannerPersistentEntity;
    private final SpannerPersistentProperty[] primaryKeyColumns;

    public SpannerCompositeKeyProperty(SpannerPersistentEntity spannerPersistentEntity, SpannerPersistentProperty[] primaryKeyColumns) {
        Assert.notNull((Object)spannerPersistentEntity, (String)"A valid Spanner persistent entity is required.");
        Assert.notNull((Object)primaryKeyColumns, (String)"A valid array of primary key properties is required.");
        this.primaryKeyColumns = primaryKeyColumns;
        this.spannerPersistentEntity = spannerPersistentEntity;
    }

    Key getId(Object entity) {
        PersistentPropertyAccessor accessor = this.getOwner().getPropertyAccessor(entity);
        Key.Builder keyBuilder = Key.newBuilder();
        for (SpannerPersistentProperty spannerPersistentProperty : this.primaryKeyColumns) {
            keyBuilder.appendObject(accessor.getProperty((PersistentProperty)spannerPersistentProperty));
        }
        return keyBuilder.build();
    }

    @Override
    public String getColumnName() {
        return null;
    }

    @Override
    public Class getColumnInnerType() {
        return null;
    }

    @Override
    public OptionalInt getPrimaryKeyOrder() {
        return null;
    }

    public PersistentEntity<?, SpannerPersistentProperty> getOwner() {
        return this.spannerPersistentEntity;
    }

    public String getName() {
        return null;
    }

    public Class<?> getType() {
        return Key.class;
    }

    public TypeInformation<?> getTypeInformation() {
        return ClassTypeInformation.from(this.getType());
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        return Collections.emptySet();
    }

    @Nullable
    public Method getGetter() {
        return null;
    }

    @Nullable
    public Method getSetter() {
        return null;
    }

    @Nullable
    public Field getField() {
        return null;
    }

    @Nullable
    public String getSpelExpression() {
        return null;
    }

    @Nullable
    public Association<SpannerPersistentProperty> getAssociation() {
        return null;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isIdProperty() {
        return true;
    }

    public boolean isVersionProperty() {
        return false;
    }

    public boolean isCollectionLike() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isAssociation() {
        return false;
    }

    @Nullable
    public Class<?> getComponentType() {
        return null;
    }

    public Class<?> getRawType() {
        return this.getType();
    }

    @Nullable
    public Class<?> getMapValueType() {
        return null;
    }

    public Class<?> getActualType() {
        return this.getType();
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return null;
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    public boolean usePropertyAccess() {
        return false;
    }
}

