/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.springframework.cloud.gcp.data.spanner.core.convert.AbstractSpannerCustomConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;

public class MappingSpannerWriteConverter
extends AbstractSpannerCustomConverter
implements EntityWriter<Object, Mutation.WriteBuilder> {
    private static final Map<Class, BiConsumer<ValueBinder<Mutation.WriteBuilder>, Iterable>> iterablePropertyType2ToMethodMap;
    public static final Map<Class, BiFunction<ValueBinder, ?, ?>> singleItemType2ToMethodMap;
    private final SpannerMappingContext spannerMappingContext;

    MappingSpannerWriteConverter(SpannerMappingContext spannerMappingContext, CustomConversions customConversions) {
        super(customConversions, null);
        this.spannerMappingContext = spannerMappingContext;
    }

    public void write(Object source, Mutation.WriteBuilder sink) {
        this.write(source, sink, null);
    }

    public void write(Object source, Mutation.WriteBuilder sink, Set<String> includeColumns) {
        boolean writeAllColumns = includeColumns == null;
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(source.getClass());
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(source);
        persistentEntity.doWithProperties(spannerPersistentProperty -> {
            if (!writeAllColumns && !includeColumns.contains(spannerPersistentProperty.getColumnName())) {
                return;
            }
            this.writeProperty(sink, accessor, (SpannerPersistentProperty)spannerPersistentProperty);
        });
    }

    private void writeProperty(Mutation.WriteBuilder sink, PersistentPropertyAccessor accessor, SpannerPersistentProperty property) {
        boolean valueSet;
        Object propertyValue = accessor.getProperty((PersistentProperty)property);
        if (propertyValue == null) {
            return;
        }
        Class propertyType = property.getType();
        ValueBinder valueBinder = sink.set(property.getColumnName());
        if (ConversionUtils.isIterableNonByteArrayType(propertyType)) {
            valueSet = this.attemptSetIterableValue((Iterable)propertyValue, (ValueBinder<Mutation.WriteBuilder>)valueBinder, property);
        } else {
            valueSet = this.attemptSetSingleItemValue(propertyValue, (ValueBinder<Mutation.WriteBuilder>)valueBinder, propertyType);
            if (!valueSet) {
                Class targetType;
                Iterator<Class> iterator = singleItemType2ToMethodMap.keySet().iterator();
                while (iterator.hasNext() && !(valueSet = this.attemptSetSingleItemValue(propertyValue, (ValueBinder<Mutation.WriteBuilder>)valueBinder, targetType = iterator.next()))) {
                }
            }
        }
        if (!valueSet) {
            throw new SpannerDataException(String.format("Unsupported mapping for type: %s", propertyValue.getClass()));
        }
    }

    private boolean attemptSetIterableValue(Iterable value, ValueBinder<Mutation.WriteBuilder> valueBinder, SpannerPersistentProperty spannerPersistentProperty) {
        Class innerType = ConversionUtils.boxIfNeeded(spannerPersistentProperty.getColumnInnerType());
        if (innerType == null) {
            return false;
        }
        boolean valueSet = false;
        if (iterablePropertyType2ToMethodMap.containsKey(innerType)) {
            iterablePropertyType2ToMethodMap.get(innerType).accept(valueBinder, value);
            valueSet = true;
        }
        if (!valueSet) {
            for (Class targetType : iterablePropertyType2ToMethodMap.keySet()) {
                if (!this.canConvert(innerType, targetType)) continue;
                BiConsumer<ValueBinder<Mutation.WriteBuilder>, Iterable> toMethod = iterablePropertyType2ToMethodMap.get(targetType);
                toMethod.accept(valueBinder, ConversionUtils.convertIterable(value, targetType, this));
                valueSet = true;
                break;
            }
        }
        return valueSet;
    }

    private boolean attemptSetSingleItemValue(Object value, ValueBinder<Mutation.WriteBuilder> valueBinder, Class targetType) {
        if (!this.canConvert(value.getClass(), targetType)) {
            return false;
        }
        Class innerType = ConversionUtils.boxIfNeeded(targetType);
        BiFunction<ValueBinder, ?, ?> toMethod = singleItemType2ToMethodMap.get(innerType);
        if (toMethod == null) {
            return false;
        }
        Object ignored = toMethod.apply(valueBinder, this.convert(value, targetType));
        return true;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put(Date.class, ValueBinder::toDateArray);
        builder.put(Boolean.class, ValueBinder::toBoolArray);
        builder.put(Long.class, ValueBinder::toInt64Array);
        builder.put(String.class, ValueBinder::toStringArray);
        builder.put(Double.class, ValueBinder::toFloat64Array);
        builder.put(Timestamp.class, ValueBinder::toTimestampArray);
        builder.put(ByteArray.class, ValueBinder::toBytesArray);
        iterablePropertyType2ToMethodMap = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put(Date.class, ValueBinder::to);
        builder.put(Boolean.class, ValueBinder::to);
        builder.put(Long.class, ValueBinder::to);
        builder.put(String.class, ValueBinder::to);
        builder.put(Double.class, ValueBinder::to);
        builder.put(Timestamp.class, ValueBinder::to);
        builder.put(ByteArray.class, ValueBinder::to);
        builder.put(double[].class, ValueBinder::toFloat64Array);
        builder.put(boolean[].class, ValueBinder::toBoolArray);
        builder.put(long[].class, ValueBinder::toInt64Array);
        singleItemType2ToMethodMap = builder.build();
    }
}

