/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.cloud.gcp.data.spanner.core.convert.AbstractSpannerCustomConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerDataException;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentProperty;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;

class MappingSpannerReadConverter
extends AbstractSpannerCustomConverter
implements EntityReader<Object, Struct> {
    private static final Map<Class, BiFunction<Struct, String, List>> readIterableMapping = new ImmutableMap.Builder().put(Boolean.class, AbstractStructReader::getBooleanList).put(Long.class, AbstractStructReader::getLongList).put(String.class, AbstractStructReader::getStringList).put(Double.class, AbstractStructReader::getDoubleList).put(Timestamp.class, AbstractStructReader::getTimestampList).put(Date.class, AbstractStructReader::getDateList).put(ByteArray.class, AbstractStructReader::getBytesList).build();
    private static final Map<Class, BiFunction<Struct, String, ?>> singleItemReadMethodMapping = new ImmutableMap.Builder().put(Boolean.class, AbstractStructReader::getBoolean).put(Long.class, AbstractStructReader::getLong).put(String.class, AbstractStructReader::getString).put(Double.class, AbstractStructReader::getDouble).put(Timestamp.class, AbstractStructReader::getTimestamp).put(Date.class, AbstractStructReader::getDate).put(ByteArray.class, AbstractStructReader::getBytes).put(double[].class, AbstractStructReader::getDoubleArray).put(long[].class, AbstractStructReader::getLongArray).put(boolean[].class, AbstractStructReader::getBooleanArray).build();
    private static final Map<Type, Class> spannerColumnTypeToJavaTypeMapping = new ImmutableMap.Builder().put((Object)Type.bool(), Boolean.class).put((Object)Type.bytes(), ByteArray.class).put((Object)Type.date(), Date.class).put((Object)Type.float64(), Double.class).put((Object)Type.int64(), Long.class).put((Object)Type.string(), String.class).put((Object)Type.array((Type)Type.float64()), double[].class).put((Object)Type.array((Type)Type.int64()), long[].class).put((Object)Type.array((Type)Type.bool()), boolean[].class).put((Object)Type.timestamp(), Timestamp.class).build();
    private final SpannerMappingContext spannerMappingContext;

    MappingSpannerReadConverter(SpannerMappingContext spannerMappingContext, CustomConversions customConversions) {
        super(customConversions, null);
        this.spannerMappingContext = spannerMappingContext;
    }

    public <R> R read(Class<R> type, Struct source, Set<String> includeColumns) {
        boolean readAllColumns = includeColumns == null;
        R object = MappingSpannerReadConverter.instantiate(type);
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(type);
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(object);
        persistentEntity.doWithProperties(spannerPersistentProperty -> {
            boolean valueSet;
            String columnName = spannerPersistentProperty.getColumnName();
            try {
                if (!readAllColumns && !includeColumns.contains(columnName) || source.isNull(columnName)) {
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                throw new SpannerDataException("Unable to read column from Spanner results: " + columnName, e);
            }
            Class propType = spannerPersistentProperty.getType();
            if (ConversionUtils.isIterableNonByteArrayType(propType)) {
                valueSet = this.attemptReadIterableValue((SpannerPersistentProperty)spannerPersistentProperty, source, columnName, accessor);
            } else {
                Class sourceType = spannerColumnTypeToJavaTypeMapping.get(source.getColumnType(columnName));
                valueSet = this.attemptReadSingleItemValue((SpannerPersistentProperty)spannerPersistentProperty, source, sourceType, columnName, accessor);
            }
            if (!valueSet) {
                throw new SpannerDataException(String.format("The value in column with name %s could not be converted to the corresponding property in the entity. The property's type is %s.", columnName, propType));
            }
        });
        return object;
    }

    public <R> R read(Class<R> type, Struct source) {
        return this.read(type, source, null);
    }

    private boolean attemptReadSingleItemValue(SpannerPersistentProperty spannerPersistentProperty, Struct struct, Class sourceType, String colName, PersistentPropertyAccessor accessor) {
        Class targetType = spannerPersistentProperty.getType();
        if (sourceType == null || !this.canConvert(sourceType, targetType)) {
            return false;
        }
        BiFunction<Struct, String, ?> readFunction = singleItemReadMethodMapping.get(ConversionUtils.boxIfNeeded(sourceType));
        if (readFunction == null) {
            return false;
        }
        accessor.setProperty((PersistentProperty)spannerPersistentProperty, this.convert(readFunction.apply(struct, colName), targetType));
        return true;
    }

    private boolean attemptReadIterableValue(SpannerPersistentProperty spannerPersistentProperty, Struct struct, String colName, PersistentPropertyAccessor accessor) {
        Class innerType = ConversionUtils.boxIfNeeded(spannerPersistentProperty.getColumnInnerType());
        if (innerType == null) {
            return false;
        }
        boolean valueSet = false;
        if (readIterableMapping.containsKey(innerType)) {
            accessor.setProperty((PersistentProperty)spannerPersistentProperty, (Object)readIterableMapping.get(innerType).apply(struct, colName));
            valueSet = true;
        }
        if (!valueSet) {
            for (Class sourceType : readIterableMapping.keySet()) {
                if (!this.canConvert(sourceType, innerType)) continue;
                List iterableValue = readIterableMapping.get(sourceType).apply(struct, colName);
                accessor.setProperty((PersistentProperty)spannerPersistentProperty, (Object)ConversionUtils.convertIterable(iterableValue, innerType, this));
                valueSet = true;
                break;
            }
        }
        if (!valueSet && struct.getColumnType(colName).getArrayElementType().getCode() == Type.Code.STRUCT) {
            List iterableValue = struct.getStructList(colName);
            Iterable convertedIterableValue = StreamSupport.stream(iterableValue.spliterator(), false).map(item -> this.read((Class)innerType, (Struct)item)).collect(Collectors.toList());
            accessor.setProperty((PersistentProperty)spannerPersistentProperty, (Object)convertedIterableValue);
            valueSet = true;
        }
        return valueSet;
    }

    private static <R> R instantiate(Class<R> type) {
        R object;
        try {
            Constructor<R> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            object = constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new SpannerDataException("Unable to create a new instance of entity using default constructor.", e);
        }
        return object;
    }
}

