/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.cloud.gcp.data.spanner.core.convert.MappingSpannerReadConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.MappingSpannerWriteConverter;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.util.Assert;

public class MappingSpannerConverter
implements SpannerConverter {
    private final MappingSpannerReadConverter readConverter;
    private final MappingSpannerWriteConverter writeConverter;

    public MappingSpannerConverter(SpannerMappingContext spannerMappingContext) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Spanner is required.");
        this.readConverter = new MappingSpannerReadConverter(spannerMappingContext, this.getCustomConversions(ConversionUtils.DEFAULT_SPANNER_READ_CONVERTERS));
        this.writeConverter = new MappingSpannerWriteConverter(spannerMappingContext, this.getCustomConversions(ConversionUtils.DEFAULT_SPANNER_WRITE_CONVERTERS));
    }

    public MappingSpannerConverter(SpannerMappingContext spannerMappingContext, Collection<Converter> writeConverters, Collection<Converter> readConverters) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Spanner is required.");
        this.readConverter = new MappingSpannerReadConverter(spannerMappingContext, this.getCustomConversions(readConverters));
        this.writeConverter = new MappingSpannerWriteConverter(spannerMappingContext, this.getCustomConversions(writeConverters));
    }

    public MappingSpannerConverter(SpannerMappingContext spannerMappingContext, CustomConversions writeConversions, CustomConversions readConversions) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Spanner is required.");
        this.readConverter = new MappingSpannerReadConverter(spannerMappingContext, readConversions);
        this.writeConverter = new MappingSpannerWriteConverter(spannerMappingContext, writeConversions);
    }

    private CustomConversions getCustomConversions(Collection<Converter> converters) {
        return new CustomConversions(CustomConversions.StoreConversions.NONE, converters);
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass) {
        return this.mapToList(resultSet, entityClass, Optional.empty());
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass, Optional<Set<String>> includeColumns) {
        ArrayList<T> result = new ArrayList<T>();
        while (resultSet.next()) {
            result.add(this.readConverter.read(entityClass, resultSet.getCurrentRowAsStruct(), includeColumns == null || !includeColumns.isPresent() ? null : includeColumns.get()));
        }
        resultSet.close();
        return result;
    }

    @Override
    public <T> List<T> mapToList(ResultSet resultSet, Class<T> entityClass, String ... includeColumns) {
        return this.mapToList(resultSet, entityClass, includeColumns.length == 0 ? Optional.empty() : Optional.of(new HashSet<String>(Arrays.asList(includeColumns))));
    }

    @Override
    public void write(Object source, Mutation.WriteBuilder sink, Set<String> includeColumns) {
        this.writeConverter.write(source, sink, includeColumns);
    }

    public void write(Object source, Mutation.WriteBuilder sink) {
        this.writeConverter.write(source, sink);
    }

    public <R> R read(Class<R> type, Struct source) {
        return this.readConverter.read(type, source);
    }
}

