/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core.convert;

import org.springframework.cloud.gcp.data.spanner.core.convert.ConversionUtils;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.util.Assert;

public abstract class AbstractSpannerCustomConverter {
    private final CustomConversions customConversions;
    private final ConfigurableConversionService conversionService;

    public AbstractSpannerCustomConverter(CustomConversions customConversions, GenericConversionService conversionService) {
        Assert.notNull((Object)customConversions, (String)"Valid custom conversions are required!");
        this.customConversions = customConversions;
        this.conversionService = conversionService == null ? new DefaultConversionService() : conversionService;
        this.customConversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    protected boolean canConvert(Class sourceType, Class targetType) {
        Class boxedTargetType = ConversionUtils.boxIfNeeded(targetType);
        Class boxedSourceType = ConversionUtils.boxIfNeeded(sourceType);
        return boxedSourceType.equals(boxedTargetType) || this.conversionService.canConvert(boxedSourceType, boxedTargetType);
    }

    protected Object convert(Object source, Class targetType) {
        Class boxedTargetType = ConversionUtils.boxIfNeeded(targetType);
        return ConversionUtils.boxIfNeeded(source.getClass()).equals(boxedTargetType) ? source : this.conversionService.convert(source, boxedTargetType);
    }
}

