/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.springframework.cloud.gcp.data.spanner.core.ReadOnlyTransactionSpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.ReadWriteTransactionSpannerTemplate;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.SpannerOperations;
import org.springframework.cloud.gcp.data.spanner.core.SpannerQueryOptions;
import org.springframework.cloud.gcp.data.spanner.core.SpannerReadOptions;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.cloud.gcp.data.spanner.repository.query.SpannerStatementQueryExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SpannerTemplate
implements SpannerOperations {
    private final DatabaseClient databaseClient;
    private final SpannerMappingContext mappingContext;
    private final SpannerConverter spannerConverter;
    private final SpannerMutationFactory mutationFactory;

    public SpannerTemplate(DatabaseClient databaseClient, SpannerMappingContext mappingContext, SpannerConverter spannerConverter, SpannerMutationFactory spannerMutationFactory) {
        Assert.notNull((Object)databaseClient, (String)"A valid database client for Spanner is required.");
        Assert.notNull((Object)((Object)mappingContext), (String)"A valid mapping context for Spanner is required.");
        Assert.notNull((Object)spannerConverter, (String)"A valid results mapper for Spanner is required.");
        Assert.notNull((Object)spannerMutationFactory, (String)"A valid Spanner mutation factory is required.");
        this.databaseClient = databaseClient;
        this.mappingContext = mappingContext;
        this.spannerConverter = spannerConverter;
        this.mutationFactory = spannerMutationFactory;
    }

    protected ReadContext getReadContext() {
        return this.databaseClient.singleUse();
    }

    protected ReadContext getReadContext(Timestamp timestamp) {
        return this.databaseClient.singleUse(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
    }

    public SpannerMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key) {
        return this.read(entityClass, key, null);
    }

    @Override
    public <T> T read(Class<T> entityClass, Key key, SpannerReadOptions options) {
        List<T> items = this.read(entityClass, KeySet.singleKey((Key)key), options);
        return items.isEmpty() ? null : (T)items.get(0);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys) {
        return this.read(entityClass, keys, null);
    }

    @Override
    public <T> List<T> read(Class<T> entityClass, KeySet keys, SpannerReadOptions options) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        return this.spannerConverter.mapToList(this.executeRead(persistentEntity.tableName(), keys, persistentEntity.columns(), options), entityClass);
    }

    @Override
    public <T> List<T> query(Class<T> entityClass, Statement statement, SpannerQueryOptions options) {
        return this.spannerConverter.mapToList(this.executeQuery(statement, options), entityClass);
    }

    @Override
    public <T> List<T> query(Class<T> entityClass, Statement statement) {
        return this.query(entityClass, statement, null);
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass, SpannerReadOptions options) {
        return this.read(entityClass, KeySet.all(), options);
    }

    @Override
    public <T> List<T> readAll(Class<T> entityClass) {
        return this.readAll(entityClass, null);
    }

    @Override
    public <T> List<T> queryAll(Class<T> entityClass, Sort sort) {
        return this.queryAll(entityClass, sort, null);
    }

    @Override
    public <T> List<T> queryAll(Class<T> entityClass, Sort sort, SpannerQueryOptions options) {
        Assert.notNull((Object)sort, (String)"sort must not be null!");
        StringBuilder stringBuilder = new StringBuilder();
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        stringBuilder.append("SELECT * FROM " + persistentEntity.tableName() + " ");
        SpannerStatementQueryExecutor.buildOrderBy(persistentEntity, stringBuilder, sort);
        if (options != null) {
            if (options.hasLimit()) {
                stringBuilder.append(" LIMIT " + options.getLimit());
            }
            if (options.hasLimit()) {
                stringBuilder.append(" OFFSET " + options.getOffset());
            }
        }
        stringBuilder.append(";");
        return this.query(entityClass, Statement.of((String)stringBuilder.toString()), options);
    }

    @Override
    public <T> Page<T> queryAll(Class<T> entityClass, Pageable pageable, SpannerQueryOptions options) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        Long count = this.count(entityClass);
        List<T> list = this.queryAll(entityClass, pageable.getSort(), options);
        return new PageImpl(list, pageable, count.longValue());
    }

    @Override
    public <T> Page<T> queryAll(Class<T> entityClass, Pageable pageable) {
        return this.queryAll(entityClass, pageable, null);
    }

    @Override
    public void insert(Object object) {
        this.applyMutationUsingEntity(this.mutationFactory::insert, object);
    }

    @Override
    public void update(Object object) {
        this.applyMutationTwoArgs(this.mutationFactory::update, object, null);
    }

    @Override
    public void update(Object object, String ... includeColumns) {
        this.applyMutationTwoArgs(this.mutationFactory::update, object, includeColumns.length == 0 ? null : Optional.of(new HashSet<String>(Arrays.asList(includeColumns))));
    }

    @Override
    public void update(Object object, Optional<Set<String>> includeColumns) {
        this.applyMutationTwoArgs(this.mutationFactory::update, object, includeColumns);
    }

    @Override
    public void upsert(Object object) {
        this.applyMutationTwoArgs(this.mutationFactory::upsert, object, null);
    }

    @Override
    public void upsert(Object object, String ... includeColumns) {
        this.applyMutationTwoArgs(this.mutationFactory::upsert, object, includeColumns.length == 0 ? null : Optional.of(new HashSet<String>(Arrays.asList(includeColumns))));
    }

    @Override
    public void upsert(Object object, Optional<Set<String>> includeColumns) {
        this.applyMutationTwoArgs(this.mutationFactory::upsert, object, includeColumns);
    }

    @Override
    public void delete(Object entity) {
        this.applyMutationUsingEntity(this.mutationFactory::delete, entity);
    }

    @Override
    public void delete(Class entityClass, Key key) {
        this.applyMutationTwoArgs(this.mutationFactory::delete, entityClass, key);
    }

    @Override
    public <T> void delete(Class<T> entityClass, Iterable<? extends T> entities) {
        this.applyMutationTwoArgs(this.mutationFactory::delete, entityClass, entities);
    }

    @Override
    public void delete(Class entityClass, KeySet keys) {
        this.applyMutationTwoArgs(this.mutationFactory::delete, entityClass, keys);
    }

    @Override
    public long count(Class entityClass) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        Statement statement = Statement.of((String)String.format("select count(*) from %s", persistentEntity.tableName()));
        try (ResultSet resultSet = this.executeQuery(statement, null);){
            resultSet.next();
            long l = resultSet.getLong(0);
            return l;
        }
    }

    @Override
    public <T> T performReadWriteTransaction(final Function<SpannerOperations, T> operations) {
        return (T)this.databaseClient.readWriteTransaction().run(new TransactionRunner.TransactionCallable<T>(){

            @Nullable
            public T run(TransactionContext transaction) throws Exception {
                ReadWriteTransactionSpannerTemplate transactionSpannerTemplate = new ReadWriteTransactionSpannerTemplate(SpannerTemplate.this.databaseClient, SpannerTemplate.this.mappingContext, SpannerTemplate.this.spannerConverter, SpannerTemplate.this.mutationFactory, transaction);
                return operations.apply(transactionSpannerTemplate);
            }
        });
    }

    @Override
    public <T> T performReadOnlyTransaction(Function<SpannerOperations, T> operations, SpannerReadOptions readOptions) {
        try (ReadOnlyTransaction readOnlyTransaction = readOptions.hasTimestamp() ? this.databaseClient.readOnlyTransaction(TimestampBound.ofReadTimestamp((Timestamp)readOptions.getTimestamp())) : this.databaseClient.readOnlyTransaction();){
            T t = operations.apply(new ReadOnlyTransactionSpannerTemplate(this.databaseClient, this.mappingContext, this.spannerConverter, this.mutationFactory, readOnlyTransaction));
            return t;
        }
    }

    private ResultSet executeRead(String tableName, KeySet keys, Iterable<String> columns, SpannerReadOptions options) {
        ReadContext readContext;
        if (options == null) {
            return this.getReadContext().read(tableName, keys, columns, new Options.ReadOption[0]);
        }
        ReadContext readContext2 = readContext = options.hasTimestamp() ? this.getReadContext(options.getTimestamp()) : this.getReadContext();
        if (options.hasIndex()) {
            return readContext.readUsingIndex(tableName, options.getIndex(), keys, columns, options.getReadOptions());
        }
        return readContext.read(tableName, keys, columns, options.getReadOptions());
    }

    private ResultSet executeQuery(Statement statement, SpannerQueryOptions options) {
        if (options == null) {
            return this.getReadContext().executeQuery(statement, new Options.QueryOption[0]);
        }
        return (options.hasTimestamp() ? this.getReadContext(options.getTimestamp()) : this.getReadContext()).executeQuery(statement, options.getQueryOptions());
    }

    protected <T, U> void applyMutationTwoArgs(BiFunction<T, U, Mutation> function, T arg1, U arg2) {
        this.databaseClient.write(Arrays.asList(function.apply(arg1, arg2)));
    }

    private <T> void applyMutationUsingEntity(Function<T, Mutation> function, T arg) {
        this.applyMutationTwoArgs((t, unused) -> (Mutation)function.apply(t), arg, null);
    }
}

