/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.Assert;

public class SpannerReadOptions {
    private List<Options.ReadOption> readOptions = new ArrayList<Options.ReadOption>();
    private Optional<Timestamp> timestamp = Optional.empty();
    private Optional<String> index = Optional.empty();

    public SpannerReadOptions addReadOption(Options.ReadOption readOption) {
        Assert.notNull((Object)readOption, (String)"Valid read option is required!");
        this.readOptions.add(readOption);
        return this;
    }

    public SpannerReadOptions unsetTimestamp() {
        this.timestamp = Optional.empty();
        return this;
    }

    public boolean hasTimestamp() {
        return this.timestamp.isPresent();
    }

    public Timestamp getTimestamp() {
        if (!this.hasTimestamp()) {
            throw new UnsupportedOperationException("Cannot get timestamp because it hasn't been set.");
        }
        return this.timestamp.get();
    }

    public SpannerReadOptions setTimestamp(Timestamp timestamp) {
        Assert.notNull((Object)timestamp, (String)"A valid timestamp is required!");
        this.timestamp = Optional.of(timestamp);
        return this;
    }

    public SpannerReadOptions unsetIndex() {
        this.index = Optional.empty();
        return this;
    }

    public boolean hasIndex() {
        return this.index.isPresent();
    }

    public String getIndex() {
        if (!this.hasIndex()) {
            throw new UnsupportedOperationException("Cannot get index because it hasn't been set.");
        }
        return this.index.get();
    }

    public SpannerReadOptions setIndex(String index) {
        Assert.notNull((Object)index, (String)"A valid index is required!");
        this.index = Optional.of(index);
        return this;
    }

    public Options.ReadOption[] getReadOptions() {
        return this.readOptions.toArray(new Options.ReadOption[this.readOptions.size()]);
    }
}

