/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.springframework.util.Assert;

public class SpannerQueryOptions {
    private List<Options.QueryOption> queryOptions = new ArrayList<Options.QueryOption>();
    private Optional<Timestamp> timestamp = Optional.empty();
    private OptionalLong limit = OptionalLong.empty();
    private OptionalLong offset = OptionalLong.empty();

    public SpannerQueryOptions addQueryOption(Options.QueryOption queryOption) {
        Assert.notNull((Object)queryOption, (String)"Valid query option is required!");
        this.queryOptions.add(queryOption);
        return this;
    }

    public SpannerQueryOptions unsetTimestamp() {
        this.timestamp = Optional.empty();
        return this;
    }

    public SpannerQueryOptions unsetLimit() {
        this.limit = OptionalLong.empty();
        return this;
    }

    public SpannerQueryOptions unsetOffset() {
        this.offset = OptionalLong.empty();
        return this;
    }

    public boolean hasTimestamp() {
        return this.timestamp.isPresent();
    }

    public Timestamp getTimestamp() {
        if (!this.hasTimestamp()) {
            throw new UnsupportedOperationException("Cannot get timestamp because it hasn't been set.");
        }
        return this.timestamp.get();
    }

    public SpannerQueryOptions setTimestamp(Timestamp timestamp) {
        Assert.notNull((Object)timestamp, (String)"A valid timestamp is required!");
        this.timestamp = Optional.of(timestamp);
        return this;
    }

    public boolean hasLimit() {
        return this.limit.isPresent();
    }

    public long getLimit() {
        if (!this.hasLimit()) {
            throw new UnsupportedOperationException("Cannot get limit because it hasn't been set.");
        }
        return this.limit.getAsLong();
    }

    public SpannerQueryOptions setLimit(long limit) {
        this.limit = OptionalLong.of(limit);
        return this;
    }

    public boolean hasOffset() {
        return this.offset.isPresent();
    }

    public long getOffset() {
        if (!this.hasOffset()) {
            throw new UnsupportedOperationException("Cannot get offset because it hasn't been set.");
        }
        return this.offset.getAsLong();
    }

    public SpannerQueryOptions setOffset(long offset) {
        this.offset = OptionalLong.of(offset);
        return this;
    }

    public Options.QueryOption[] getQueryOptions() {
        return this.queryOptions.toArray(new Options.QueryOption[this.queryOptions.size()]);
    }
}

