/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.data.spanner.core;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import org.springframework.cloud.gcp.data.spanner.core.SpannerMutationFactory;
import org.springframework.cloud.gcp.data.spanner.core.convert.SpannerConverter;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerMappingContext;
import org.springframework.cloud.gcp.data.spanner.core.mapping.SpannerPersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.util.Assert;

public class SpannerMutationFactoryImpl
implements SpannerMutationFactory {
    private final SpannerConverter spannerConverter;
    private final SpannerMappingContext spannerMappingContext;

    public SpannerMutationFactoryImpl(SpannerConverter spannerConverter, SpannerMappingContext spannerMappingContext) {
        Assert.notNull((Object)spannerConverter, (String)"A valid results mapper for Spanner is required.");
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Spanner is required.");
        this.spannerConverter = spannerConverter;
        this.spannerMappingContext = spannerMappingContext;
    }

    @Override
    public Mutation insert(Object object) {
        return this.saveObject(Mutation.Op.INSERT, object, null);
    }

    @Override
    public Mutation upsert(Object object, Optional<Set<String>> includeColumns) {
        return this.saveObject(Mutation.Op.INSERT_OR_UPDATE, object, includeColumns == null || !includeColumns.isPresent() ? null : includeColumns.get());
    }

    @Override
    public Mutation update(Object object, Optional<Set<String>> includeColumns) {
        return this.saveObject(Mutation.Op.UPDATE, object, includeColumns == null || !includeColumns.isPresent() ? null : includeColumns.get());
    }

    @Override
    public <T> Mutation delete(Class<T> entityClass, Iterable<? extends T> entities) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(entityClass);
        KeySet.Builder builder = KeySet.newBuilder();
        for (T entity : entities) {
            PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(entity);
            PersistentProperty idProperty = persistentEntity.getIdProperty();
            Key value = (Key)accessor.getProperty(idProperty);
            builder.addKey(value);
        }
        return this.delete(entityClass, builder.build());
    }

    @Override
    public Mutation delete(Object object) {
        return this.delete(object.getClass(), Arrays.asList(object));
    }

    @Override
    public Mutation delete(Class entityClass, KeySet keys) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(entityClass);
        return Mutation.delete((String)persistentEntity.tableName(), (KeySet)keys);
    }

    @Override
    public Mutation delete(Class entityClass, Key key) {
        return this.delete(entityClass, KeySet.singleKey((Key)key));
    }

    private Mutation saveObject(Mutation.Op op, Object object, Set<String> includeColumns) {
        SpannerPersistentEntity persistentEntity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(object.getClass());
        Mutation.WriteBuilder writeBuilder = this.writeBuilder(op, persistentEntity.tableName());
        this.spannerConverter.write(object, writeBuilder, includeColumns);
        return writeBuilder.build();
    }

    private Mutation.WriteBuilder writeBuilder(Mutation.Op op, String tableName) {
        Mutation.WriteBuilder builder = null;
        switch (op) {
            case INSERT: {
                builder = Mutation.newInsertBuilder((String)tableName);
                break;
            }
            case INSERT_OR_UPDATE: {
                builder = Mutation.newInsertOrUpdateBuilder((String)tableName);
                break;
            }
            case UPDATE: {
                builder = Mutation.newUpdateBuilder((String)tableName);
            }
        }
        if (builder == null) {
            throw new IllegalArgumentException("Unsupported save-mutation operation: " + op);
        }
        return builder;
    }
}

